// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Source or target connection reference details.
 */
@Fluent
public final class MapperConnectionReference {
    /*
     * Name of the connection
     */
    @JsonProperty(value = "connectionName")
    private String connectionName;

    /*
     * Type of connection via linked service or dataset.
     */
    @JsonProperty(value = "type")
    private ConnectionType type;

    /**
     * Creates an instance of MapperConnectionReference class.
     */
    public MapperConnectionReference() {
    }

    /**
     * Get the connectionName property: Name of the connection.
     * 
     * @return the connectionName value.
     */
    public String connectionName() {
        return this.connectionName;
    }

    /**
     * Set the connectionName property: Name of the connection.
     * 
     * @param connectionName the connectionName value to set.
     * @return the MapperConnectionReference object itself.
     */
    public MapperConnectionReference withConnectionName(String connectionName) {
        this.connectionName = connectionName;
        return this;
    }

    /**
     * Get the type property: Type of connection via linked service or dataset.
     * 
     * @return the type value.
     */
    public ConnectionType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of connection via linked service or dataset.
     * 
     * @param type the type value to set.
     * @return the MapperConnectionReference object itself.
     */
    public MapperConnectionReference withType(ConnectionType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
