// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * CDC Policy.
 */
@Fluent
public final class MapperPolicy {
    /*
     * Mode of running the CDC: batch vs continuous.
     */
    @JsonProperty(value = "mode")
    private String mode;

    /*
     * Defines the frequency and interval for running the CDC for batch mode.
     */
    @JsonProperty(value = "recurrence")
    private MapperPolicyRecurrence recurrence;

    /**
     * Creates an instance of MapperPolicy class.
     */
    public MapperPolicy() {
    }

    /**
     * Get the mode property: Mode of running the CDC: batch vs continuous.
     * 
     * @return the mode value.
     */
    public String mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Mode of running the CDC: batch vs continuous.
     * 
     * @param mode the mode value to set.
     * @return the MapperPolicy object itself.
     */
    public MapperPolicy withMode(String mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the recurrence property: Defines the frequency and interval for running the CDC for batch mode.
     * 
     * @return the recurrence value.
     */
    public MapperPolicyRecurrence recurrence() {
        return this.recurrence;
    }

    /**
     * Set the recurrence property: Defines the frequency and interval for running the CDC for batch mode.
     * 
     * @param recurrence the recurrence value to set.
     * @return the MapperPolicy object itself.
     */
    public MapperPolicy withRecurrence(MapperPolicyRecurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (recurrence() != null) {
            recurrence().validate();
        }
    }
}
