// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * CDC policy recurrence details.
 */
@Fluent
public final class MapperPolicyRecurrence {
    /*
     * Frequency of period in terms of 'Hour', 'Minute' or 'Second'.
     */
    @JsonProperty(value = "frequency")
    private FrequencyType frequency;

    /*
     * Actual interval value as per chosen frequency.
     */
    @JsonProperty(value = "interval")
    private Integer interval;

    /**
     * Creates an instance of MapperPolicyRecurrence class.
     */
    public MapperPolicyRecurrence() {
    }

    /**
     * Get the frequency property: Frequency of period in terms of 'Hour', 'Minute' or 'Second'.
     * 
     * @return the frequency value.
     */
    public FrequencyType frequency() {
        return this.frequency;
    }

    /**
     * Set the frequency property: Frequency of period in terms of 'Hour', 'Minute' or 'Second'.
     * 
     * @param frequency the frequency value to set.
     * @return the MapperPolicyRecurrence object itself.
     */
    public MapperPolicyRecurrence withFrequency(FrequencyType frequency) {
        this.frequency = frequency;
        return this;
    }

    /**
     * Get the interval property: Actual interval value as per chosen frequency.
     * 
     * @return the interval value.
     */
    public Integer interval() {
        return this.interval;
    }

    /**
     * Set the interval property: Actual interval value as per chosen frequency.
     * 
     * @param interval the interval value to set.
     * @return the MapperPolicyRecurrence object itself.
     */
    public MapperPolicyRecurrence withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
