// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A object which contains list of tables and connection details for a source connection.
 */
@Fluent
public final class MapperSourceConnectionsInfo {
    /*
     * List of source tables for a source connection.
     */
    @JsonProperty(value = "sourceEntities")
    private List<MapperTable> sourceEntities;

    /*
     * Source connection details.
     */
    @JsonProperty(value = "connection")
    private MapperConnection connection;

    /**
     * Creates an instance of MapperSourceConnectionsInfo class.
     */
    public MapperSourceConnectionsInfo() {
    }

    /**
     * Get the sourceEntities property: List of source tables for a source connection.
     * 
     * @return the sourceEntities value.
     */
    public List<MapperTable> sourceEntities() {
        return this.sourceEntities;
    }

    /**
     * Set the sourceEntities property: List of source tables for a source connection.
     * 
     * @param sourceEntities the sourceEntities value to set.
     * @return the MapperSourceConnectionsInfo object itself.
     */
    public MapperSourceConnectionsInfo withSourceEntities(List<MapperTable> sourceEntities) {
        this.sourceEntities = sourceEntities;
        return this;
    }

    /**
     * Get the connection property: Source connection details.
     * 
     * @return the connection value.
     */
    public MapperConnection connection() {
        return this.connection;
    }

    /**
     * Set the connection property: Source connection details.
     * 
     * @param connection the connection value to set.
     * @return the MapperSourceConnectionsInfo object itself.
     */
    public MapperSourceConnectionsInfo withConnection(MapperConnection connection) {
        this.connection = connection;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceEntities() != null) {
            sourceEntities().forEach(e -> e.validate());
        }
        if (connection() != null) {
            connection().validate();
        }
    }
}
