// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.fluent.models.MapperTableProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * CDC table details.
 */
@Fluent
public final class MapperTable {
    /*
     * Name of the table.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Table properties.
     */
    @JsonProperty(value = "properties")
    private MapperTableProperties innerProperties;

    /**
     * Creates an instance of MapperTable class.
     */
    public MapperTable() {
    }

    /**
     * Get the name property: Name of the table.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the table.
     * 
     * @param name the name value to set.
     * @return the MapperTable object itself.
     */
    public MapperTable withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the innerProperties property: Table properties.
     * 
     * @return the innerProperties value.
     */
    private MapperTableProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the schema property: List of columns for the source table.
     * 
     * @return the schema value.
     */
    public List<MapperTableSchema> schema() {
        return this.innerProperties() == null ? null : this.innerProperties().schema();
    }

    /**
     * Set the schema property: List of columns for the source table.
     * 
     * @param schema the schema value to set.
     * @return the MapperTable object itself.
     */
    public MapperTable withSchema(List<MapperTableSchema> schema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MapperTableProperties();
        }
        this.innerProperties().withSchema(schema);
        return this;
    }

    /**
     * Get the dslConnectorProperties property: List of name/value pairs for connection properties.
     * 
     * @return the dslConnectorProperties value.
     */
    public List<MapperDslConnectorProperties> dslConnectorProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().dslConnectorProperties();
    }

    /**
     * Set the dslConnectorProperties property: List of name/value pairs for connection properties.
     * 
     * @param dslConnectorProperties the dslConnectorProperties value to set.
     * @return the MapperTable object itself.
     */
    public MapperTable withDslConnectorProperties(List<MapperDslConnectorProperties> dslConnectorProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MapperTableProperties();
        }
        this.innerProperties().withDslConnectorProperties(dslConnectorProperties);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
