// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Schema of a CDC table in terms of column names and their corresponding data types.
 */
@Fluent
public final class MapperTableSchema {
    /*
     * Name of the column.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Data type of the column.
     */
    @JsonProperty(value = "dataType")
    private String dataType;

    /**
     * Creates an instance of MapperTableSchema class.
     */
    public MapperTableSchema() {
    }

    /**
     * Get the name property: Name of the column.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the column.
     * 
     * @param name the name value to set.
     * @return the MapperTableSchema object itself.
     */
    public MapperTableSchema withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the dataType property: Data type of the column.
     * 
     * @return the dataType value.
     */
    public String dataType() {
        return this.dataType;
    }

    /**
     * Set the dataType property: Data type of the column.
     * 
     * @param dataType the dataType value to set.
     * @return the MapperTableSchema object itself.
     */
    public MapperTableSchema withDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
