// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A object which contains list of tables and connection details for a target connection.
 */
@Fluent
public final class MapperTargetConnectionsInfo {
    /*
     * List of source tables for a target connection.
     */
    @JsonProperty(value = "targetEntities")
    private List<MapperTable> targetEntities;

    /*
     * Source connection details.
     */
    @JsonProperty(value = "connection")
    private MapperConnection connection;

    /*
     * List of table mappings.
     */
    @JsonProperty(value = "dataMapperMappings")
    private List<DataMapperMapping> dataMapperMappings;

    /*
     * List of relationship info among the tables.
     */
    @JsonProperty(value = "relationships")
    private List<Object> relationships;

    /**
     * Creates an instance of MapperTargetConnectionsInfo class.
     */
    public MapperTargetConnectionsInfo() {
    }

    /**
     * Get the targetEntities property: List of source tables for a target connection.
     * 
     * @return the targetEntities value.
     */
    public List<MapperTable> targetEntities() {
        return this.targetEntities;
    }

    /**
     * Set the targetEntities property: List of source tables for a target connection.
     * 
     * @param targetEntities the targetEntities value to set.
     * @return the MapperTargetConnectionsInfo object itself.
     */
    public MapperTargetConnectionsInfo withTargetEntities(List<MapperTable> targetEntities) {
        this.targetEntities = targetEntities;
        return this;
    }

    /**
     * Get the connection property: Source connection details.
     * 
     * @return the connection value.
     */
    public MapperConnection connection() {
        return this.connection;
    }

    /**
     * Set the connection property: Source connection details.
     * 
     * @param connection the connection value to set.
     * @return the MapperTargetConnectionsInfo object itself.
     */
    public MapperTargetConnectionsInfo withConnection(MapperConnection connection) {
        this.connection = connection;
        return this;
    }

    /**
     * Get the dataMapperMappings property: List of table mappings.
     * 
     * @return the dataMapperMappings value.
     */
    public List<DataMapperMapping> dataMapperMappings() {
        return this.dataMapperMappings;
    }

    /**
     * Set the dataMapperMappings property: List of table mappings.
     * 
     * @param dataMapperMappings the dataMapperMappings value to set.
     * @return the MapperTargetConnectionsInfo object itself.
     */
    public MapperTargetConnectionsInfo withDataMapperMappings(List<DataMapperMapping> dataMapperMappings) {
        this.dataMapperMappings = dataMapperMappings;
        return this;
    }

    /**
     * Get the relationships property: List of relationship info among the tables.
     * 
     * @return the relationships value.
     */
    public List<Object> relationships() {
        return this.relationships;
    }

    /**
     * Set the relationships property: List of relationship info among the tables.
     * 
     * @param relationships the relationships value to set.
     * @return the MapperTargetConnectionsInfo object itself.
     */
    public MapperTargetConnectionsInfo withRelationships(List<Object> relationships) {
        this.relationships = relationships;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (targetEntities() != null) {
            targetEntities().forEach(e -> e.validate());
        }
        if (connection() != null) {
            connection().validate();
        }
        if (dataMapperMappings() != null) {
            dataMapperMappings().forEach(e -> e.validate());
        }
    }
}
