// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.fluent.models.MappingDataFlowTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * Mapping data flow.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = MappingDataFlow.class, visible = true)
@JsonTypeName("MappingDataFlow")
@Fluent
public final class MappingDataFlow extends DataFlow {
    /*
     * Type of data flow.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "MappingDataFlow";

    /*
     * Mapping data flow type properties.
     */
    @JsonProperty(value = "typeProperties")
    private MappingDataFlowTypeProperties innerTypeProperties;

    /**
     * Creates an instance of MappingDataFlow class.
     */
    public MappingDataFlow() {
    }

    /**
     * Get the type property: Type of data flow.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Mapping data flow type properties.
     * 
     * @return the innerTypeProperties value.
     */
    private MappingDataFlowTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MappingDataFlow withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MappingDataFlow withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MappingDataFlow withFolder(DataFlowFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the sources property: List of sources in data flow.
     * 
     * @return the sources value.
     */
    public List<DataFlowSource> sources() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sources();
    }

    /**
     * Set the sources property: List of sources in data flow.
     * 
     * @param sources the sources value to set.
     * @return the MappingDataFlow object itself.
     */
    public MappingDataFlow withSources(List<DataFlowSource> sources) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MappingDataFlowTypeProperties();
        }
        this.innerTypeProperties().withSources(sources);
        return this;
    }

    /**
     * Get the sinks property: List of sinks in data flow.
     * 
     * @return the sinks value.
     */
    public List<DataFlowSink> sinks() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sinks();
    }

    /**
     * Set the sinks property: List of sinks in data flow.
     * 
     * @param sinks the sinks value to set.
     * @return the MappingDataFlow object itself.
     */
    public MappingDataFlow withSinks(List<DataFlowSink> sinks) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MappingDataFlowTypeProperties();
        }
        this.innerTypeProperties().withSinks(sinks);
        return this;
    }

    /**
     * Get the transformations property: List of transformations in data flow.
     * 
     * @return the transformations value.
     */
    public List<Transformation> transformations() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().transformations();
    }

    /**
     * Set the transformations property: List of transformations in data flow.
     * 
     * @param transformations the transformations value to set.
     * @return the MappingDataFlow object itself.
     */
    public MappingDataFlow withTransformations(List<Transformation> transformations) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MappingDataFlowTypeProperties();
        }
        this.innerTypeProperties().withTransformations(transformations);
        return this;
    }

    /**
     * Get the script property: DataFlow script.
     * 
     * @return the script value.
     */
    public String script() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().script();
    }

    /**
     * Set the script property: DataFlow script.
     * 
     * @param script the script value to set.
     * @return the MappingDataFlow object itself.
     */
    public MappingDataFlow withScript(String script) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MappingDataFlowTypeProperties();
        }
        this.innerTypeProperties().withScript(script);
        return this;
    }

    /**
     * Get the scriptLines property: Data flow script lines.
     * 
     * @return the scriptLines value.
     */
    public List<String> scriptLines() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scriptLines();
    }

    /**
     * Set the scriptLines property: Data flow script lines.
     * 
     * @param scriptLines the scriptLines value to set.
     * @return the MappingDataFlow object itself.
     */
    public MappingDataFlow withScriptLines(List<String> scriptLines) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MappingDataFlowTypeProperties();
        }
        this.innerTypeProperties().withScriptLines(scriptLines);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() != null) {
            innerTypeProperties().validate();
        }
    }
}
