// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.MongoDbAtlasCollectionDatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * The MongoDB Atlas database dataset.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = MongoDbAtlasCollectionDataset.class,
    visible = true)
@JsonTypeName("MongoDbAtlasCollection")
@Fluent
public final class MongoDbAtlasCollectionDataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "MongoDbAtlasCollection";

    /*
     * MongoDB Atlas database dataset properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private MongoDbAtlasCollectionDatasetTypeProperties innerTypeProperties
        = new MongoDbAtlasCollectionDatasetTypeProperties();

    /**
     * Creates an instance of MongoDbAtlasCollectionDataset class.
     */
    public MongoDbAtlasCollectionDataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: MongoDB Atlas database dataset properties.
     * 
     * @return the innerTypeProperties value.
     */
    private MongoDbAtlasCollectionDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDbAtlasCollectionDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDbAtlasCollectionDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDbAtlasCollectionDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDbAtlasCollectionDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDbAtlasCollectionDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDbAtlasCollectionDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDbAtlasCollectionDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the collection property: The collection name of the MongoDB Atlas database. Type: string (or Expression with
     * resultType string).
     * 
     * @return the collection value.
     */
    public Object collection() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().collection();
    }

    /**
     * Set the collection property: The collection name of the MongoDB Atlas database. Type: string (or Expression with
     * resultType string).
     * 
     * @param collection the collection value to set.
     * @return the MongoDbAtlasCollectionDataset object itself.
     */
    public MongoDbAtlasCollectionDataset withCollection(Object collection) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MongoDbAtlasCollectionDatasetTypeProperties();
        }
        this.innerTypeProperties().withCollection(collection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model MongoDbAtlasCollectionDataset"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MongoDbAtlasCollectionDataset.class);
}
