// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * Base class for all triggers that support one to many model for trigger to pipeline.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = MultiplePipelineTrigger.class,
    visible = true)
@JsonTypeName("MultiplePipelineTrigger")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "ScheduleTrigger", value = ScheduleTrigger.class),
    @JsonSubTypes.Type(name = "BlobTrigger", value = BlobTrigger.class),
    @JsonSubTypes.Type(name = "BlobEventsTrigger", value = BlobEventsTrigger.class),
    @JsonSubTypes.Type(name = "CustomEventsTrigger", value = CustomEventsTrigger.class) })
@Fluent
public class MultiplePipelineTrigger extends Trigger {
    /*
     * Trigger type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "MultiplePipelineTrigger";

    /*
     * Pipelines that need to be started.
     */
    @JsonProperty(value = "pipelines")
    private List<TriggerPipelineReference> pipelines;

    /**
     * Creates an instance of MultiplePipelineTrigger class.
     */
    public MultiplePipelineTrigger() {
    }

    /**
     * Get the type property: Trigger type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the pipelines property: Pipelines that need to be started.
     * 
     * @return the pipelines value.
     */
    public List<TriggerPipelineReference> pipelines() {
        return this.pipelines;
    }

    /**
     * Set the pipelines property: Pipelines that need to be started.
     * 
     * @param pipelines the pipelines value to set.
     * @return the MultiplePipelineTrigger object itself.
     */
    public MultiplePipelineTrigger withPipelines(List<TriggerPipelineReference> pipelines) {
        this.pipelines = pipelines;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MultiplePipelineTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MultiplePipelineTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (pipelines() != null) {
            pipelines().forEach(e -> e.validate());
        }
    }
}
