// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ODataLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Open Data Protocol (OData) linked service.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = ODataLinkedService.class, visible = true)
@JsonTypeName("OData")
@Fluent
public final class ODataLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "OData";

    /*
     * OData linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private ODataLinkedServiceTypeProperties innerTypeProperties = new ODataLinkedServiceTypeProperties();

    /**
     * Creates an instance of ODataLinkedService class.
     */
    public ODataLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: OData linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private ODataLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ODataLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ODataLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ODataLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ODataLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the url property: The URL of the OData service endpoint. Type: string (or Expression with resultType string).
     * 
     * @return the url value.
     */
    public Object url() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().url();
    }

    /**
     * Set the url property: The URL of the OData service endpoint. Type: string (or Expression with resultType string).
     * 
     * @param url the url value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withUrl(Object url) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUrl(url);
        return this;
    }

    /**
     * Get the authenticationType property: Type of authentication used to connect to the OData service.
     * 
     * @return the authenticationType value.
     */
    public ODataAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    /**
     * Set the authenticationType property: Type of authentication used to connect to the OData service.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withAuthenticationType(ODataAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    /**
     * Get the username property: User name of the OData service. Type: string (or Expression with resultType string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    /**
     * Set the username property: User name of the OData service. Type: string (or Expression with resultType string).
     * 
     * @param username the username value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    /**
     * Get the password property: Password of the OData service.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    /**
     * Set the password property: Password of the OData service.
     * 
     * @param password the password value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    /**
     * Get the authHeaders property: The additional HTTP headers in the request to RESTful API used for authorization.
     * Type: key value pairs (value should be string type).
     * 
     * @return the authHeaders value.
     */
    public Object authHeaders() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authHeaders();
    }

    /**
     * Set the authHeaders property: The additional HTTP headers in the request to RESTful API used for authorization.
     * Type: key value pairs (value should be string type).
     * 
     * @param authHeaders the authHeaders value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withAuthHeaders(Object authHeaders) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthHeaders(authHeaders);
        return this;
    }

    /**
     * Get the tenant property: Specify the tenant information (domain name or tenant ID) under which your application
     * resides. Type: string (or Expression with resultType string).
     * 
     * @return the tenant value.
     */
    public Object tenant() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenant();
    }

    /**
     * Set the tenant property: Specify the tenant information (domain name or tenant ID) under which your application
     * resides. Type: string (or Expression with resultType string).
     * 
     * @param tenant the tenant value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withTenant(Object tenant) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTenant(tenant);
        return this;
    }

    /**
     * Get the servicePrincipalId property: Specify the application id of your application registered in Azure Active
     * Directory. Type: string (or Expression with resultType string).
     * 
     * @return the servicePrincipalId value.
     */
    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    /**
     * Set the servicePrincipalId property: Specify the application id of your application registered in Azure Active
     * Directory. Type: string (or Expression with resultType string).
     * 
     * @param servicePrincipalId the servicePrincipalId value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    /**
     * Get the azureCloudType property: Indicates the azure cloud type of the service principle auth. Allowed values are
     * AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type.
     * Type: string (or Expression with resultType string).
     * 
     * @return the azureCloudType value.
     */
    public Object azureCloudType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().azureCloudType();
    }

    /**
     * Set the azureCloudType property: Indicates the azure cloud type of the service principle auth. Allowed values are
     * AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type.
     * Type: string (or Expression with resultType string).
     * 
     * @param azureCloudType the azureCloudType value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withAzureCloudType(Object azureCloudType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAzureCloudType(azureCloudType);
        return this;
    }

    /**
     * Get the aadResourceId property: Specify the resource you are requesting authorization to use Directory. Type:
     * string (or Expression with resultType string).
     * 
     * @return the aadResourceId value.
     */
    public Object aadResourceId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().aadResourceId();
    }

    /**
     * Set the aadResourceId property: Specify the resource you are requesting authorization to use Directory. Type:
     * string (or Expression with resultType string).
     * 
     * @param aadResourceId the aadResourceId value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withAadResourceId(Object aadResourceId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAadResourceId(aadResourceId);
        return this;
    }

    /**
     * Get the aadServicePrincipalCredentialType property: Specify the credential type (key or cert) is used for service
     * principal.
     * 
     * @return the aadServicePrincipalCredentialType value.
     */
    public ODataAadServicePrincipalCredentialType aadServicePrincipalCredentialType() {
        return this.innerTypeProperties() == null
            ? null
            : this.innerTypeProperties().aadServicePrincipalCredentialType();
    }

    /**
     * Set the aadServicePrincipalCredentialType property: Specify the credential type (key or cert) is used for service
     * principal.
     * 
     * @param aadServicePrincipalCredentialType the aadServicePrincipalCredentialType value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withAadServicePrincipalCredentialType(
        ODataAadServicePrincipalCredentialType aadServicePrincipalCredentialType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAadServicePrincipalCredentialType(aadServicePrincipalCredentialType);
        return this;
    }

    /**
     * Get the servicePrincipalKey property: Specify the secret of your application registered in Azure Active
     * Directory. Type: string (or Expression with resultType string).
     * 
     * @return the servicePrincipalKey value.
     */
    public SecretBase servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    /**
     * Set the servicePrincipalKey property: Specify the secret of your application registered in Azure Active
     * Directory. Type: string (or Expression with resultType string).
     * 
     * @param servicePrincipalKey the servicePrincipalKey value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withServicePrincipalKey(SecretBase servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    /**
     * Get the servicePrincipalEmbeddedCert property: Specify the base64 encoded certificate of your application
     * registered in Azure Active Directory. Type: string (or Expression with resultType string).
     * 
     * @return the servicePrincipalEmbeddedCert value.
     */
    public SecretBase servicePrincipalEmbeddedCert() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalEmbeddedCert();
    }

    /**
     * Set the servicePrincipalEmbeddedCert property: Specify the base64 encoded certificate of your application
     * registered in Azure Active Directory. Type: string (or Expression with resultType string).
     * 
     * @param servicePrincipalEmbeddedCert the servicePrincipalEmbeddedCert value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withServicePrincipalEmbeddedCert(SecretBase servicePrincipalEmbeddedCert) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalEmbeddedCert(servicePrincipalEmbeddedCert);
        return this;
    }

    /**
     * Get the servicePrincipalEmbeddedCertPassword property: Specify the password of your certificate if your
     * certificate has a password and you are using AadServicePrincipal authentication. Type: string (or Expression with
     * resultType string).
     * 
     * @return the servicePrincipalEmbeddedCertPassword value.
     */
    public SecretBase servicePrincipalEmbeddedCertPassword() {
        return this.innerTypeProperties() == null
            ? null
            : this.innerTypeProperties().servicePrincipalEmbeddedCertPassword();
    }

    /**
     * Set the servicePrincipalEmbeddedCertPassword property: Specify the password of your certificate if your
     * certificate has a password and you are using AadServicePrincipal authentication. Type: string (or Expression with
     * resultType string).
     * 
     * @param servicePrincipalEmbeddedCertPassword the servicePrincipalEmbeddedCertPassword value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService
        withServicePrincipalEmbeddedCertPassword(SecretBase servicePrincipalEmbeddedCertPassword) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalEmbeddedCertPassword(servicePrincipalEmbeddedCertPassword);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the ODataLinkedService object itself.
     */
    public ODataLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ODataLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model ODataLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ODataLinkedService.class);
}
