// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.Office365DatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * The Office365 account.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = Office365Dataset.class, visible = true)
@JsonTypeName("Office365Table")
@Fluent
public final class Office365Dataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "Office365Table";

    /*
     * Office365 dataset properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private Office365DatasetTypeProperties innerTypeProperties = new Office365DatasetTypeProperties();

    /**
     * Creates an instance of Office365Dataset class.
     */
    public Office365Dataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Office365 dataset properties.
     * 
     * @return the innerTypeProperties value.
     */
    private Office365DatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Office365Dataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Office365Dataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Office365Dataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Office365Dataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Office365Dataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Office365Dataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Office365Dataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the tableName property: Name of the dataset to extract from Office 365. Type: string (or Expression with
     * resultType string).
     * 
     * @return the tableName value.
     */
    public Object tableName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tableName();
    }

    /**
     * Set the tableName property: Name of the dataset to extract from Office 365. Type: string (or Expression with
     * resultType string).
     * 
     * @param tableName the tableName value to set.
     * @return the Office365Dataset object itself.
     */
    public Office365Dataset withTableName(Object tableName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new Office365DatasetTypeProperties();
        }
        this.innerTypeProperties().withTableName(tableName);
        return this;
    }

    /**
     * Get the predicate property: A predicate expression that can be used to filter the specific rows to extract from
     * Office 365. Type: string (or Expression with resultType string).
     * 
     * @return the predicate value.
     */
    public Object predicate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().predicate();
    }

    /**
     * Set the predicate property: A predicate expression that can be used to filter the specific rows to extract from
     * Office 365. Type: string (or Expression with resultType string).
     * 
     * @param predicate the predicate value to set.
     * @return the Office365Dataset object itself.
     */
    public Office365Dataset withPredicate(Object predicate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new Office365DatasetTypeProperties();
        }
        this.innerTypeProperties().withPredicate(predicate);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model Office365Dataset"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Office365Dataset.class);
}
