// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.resourcemanager.datafactory.fluent.models.OperationInner;

/**
 * An immutable client-side representation of Operation.
 */
public interface Operation {
    /**
     * Gets the name property: Operation name: {provider}/{resource}/{operation}.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the origin property: The intended executor of the operation.
     * 
     * @return the origin value.
     */
    String origin();

    /**
     * Gets the display property: Metadata associated with the operation.
     * 
     * @return the display value.
     */
    OperationDisplay display();

    /**
     * Gets the serviceSpecification property: Details about a service operation.
     * 
     * @return the serviceSpecification value.
     */
    OperationServiceSpecification serviceSpecification();

    /**
     * Gets the inner com.azure.resourcemanager.datafactory.fluent.models.OperationInner object.
     * 
     * @return the inner object.
     */
    OperationInner innerModel();
}
