// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines how often data for a metric becomes available.
 */
@Fluent
public final class OperationMetricAvailability {
    /*
     * The granularity for the metric.
     */
    @JsonProperty(value = "timeGrain")
    private String timeGrain;

    /*
     * Blob created in the customer storage account, per hour.
     */
    @JsonProperty(value = "blobDuration")
    private String blobDuration;

    /**
     * Creates an instance of OperationMetricAvailability class.
     */
    public OperationMetricAvailability() {
    }

    /**
     * Get the timeGrain property: The granularity for the metric.
     * 
     * @return the timeGrain value.
     */
    public String timeGrain() {
        return this.timeGrain;
    }

    /**
     * Set the timeGrain property: The granularity for the metric.
     * 
     * @param timeGrain the timeGrain value to set.
     * @return the OperationMetricAvailability object itself.
     */
    public OperationMetricAvailability withTimeGrain(String timeGrain) {
        this.timeGrain = timeGrain;
        return this;
    }

    /**
     * Get the blobDuration property: Blob created in the customer storage account, per hour.
     * 
     * @return the blobDuration value.
     */
    public String blobDuration() {
        return this.blobDuration;
    }

    /**
     * Set the blobDuration property: Blob created in the customer storage account, per hour.
     * 
     * @param blobDuration the blobDuration value to set.
     * @return the OperationMetricAvailability object itself.
     */
    public OperationMetricAvailability withBlobDuration(String blobDuration) {
        this.blobDuration = blobDuration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
