// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.fluent.models.OrcDatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * ORC dataset.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = OrcDataset.class, visible = true)
@JsonTypeName("Orc")
@Fluent
public final class OrcDataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "Orc";

    /*
     * ORC dataset properties.
     */
    @JsonProperty(value = "typeProperties")
    private OrcDatasetTypeProperties innerTypeProperties;

    /**
     * Creates an instance of OrcDataset class.
     */
    public OrcDataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: ORC dataset properties.
     * 
     * @return the innerTypeProperties value.
     */
    private OrcDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OrcDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OrcDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OrcDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OrcDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OrcDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OrcDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OrcDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the location property: The location of the ORC data storage.
     * 
     * @return the location value.
     */
    public DatasetLocation location() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().location();
    }

    /**
     * Set the location property: The location of the ORC data storage.
     * 
     * @param location the location value to set.
     * @return the OrcDataset object itself.
     */
    public OrcDataset withLocation(DatasetLocation location) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OrcDatasetTypeProperties();
        }
        this.innerTypeProperties().withLocation(location);
        return this;
    }

    /**
     * Get the orcCompressionCodec property: The data orcCompressionCodec. Type: string (or Expression with resultType
     * string).
     * 
     * @return the orcCompressionCodec value.
     */
    public Object orcCompressionCodec() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().orcCompressionCodec();
    }

    /**
     * Set the orcCompressionCodec property: The data orcCompressionCodec. Type: string (or Expression with resultType
     * string).
     * 
     * @param orcCompressionCodec the orcCompressionCodec value to set.
     * @return the OrcDataset object itself.
     */
    public OrcDataset withOrcCompressionCodec(Object orcCompressionCodec) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OrcDatasetTypeProperties();
        }
        this.innerTypeProperties().withOrcCompressionCodec(orcCompressionCodec);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() != null) {
            innerTypeProperties().validate();
        }
    }
}
