// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The data stored in Optimized Row Columnar (ORC) format.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = OrcFormat.class, visible = true)
@JsonTypeName("OrcFormat")
@Fluent
public final class OrcFormat extends DatasetStorageFormat {
    /*
     * Type of dataset storage format.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "OrcFormat";

    /**
     * Creates an instance of OrcFormat class.
     */
    public OrcFormat() {
    }

    /**
     * Get the type property: Type of dataset storage format.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OrcFormat withSerializer(Object serializer) {
        super.withSerializer(serializer);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OrcFormat withDeserializer(Object deserializer) {
        super.withDeserializer(deserializer);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
