// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.fluent.models.ParquetDatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Parquet dataset.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = ParquetDataset.class, visible = true)
@JsonTypeName("Parquet")
@Fluent
public final class ParquetDataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "Parquet";

    /*
     * Parquet dataset properties.
     */
    @JsonProperty(value = "typeProperties")
    private ParquetDatasetTypeProperties innerTypeProperties;

    /**
     * Creates an instance of ParquetDataset class.
     */
    public ParquetDataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Parquet dataset properties.
     * 
     * @return the innerTypeProperties value.
     */
    private ParquetDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ParquetDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ParquetDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ParquetDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ParquetDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ParquetDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ParquetDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ParquetDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the location property: The location of the parquet storage.
     * 
     * @return the location value.
     */
    public DatasetLocation location() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().location();
    }

    /**
     * Set the location property: The location of the parquet storage.
     * 
     * @param location the location value to set.
     * @return the ParquetDataset object itself.
     */
    public ParquetDataset withLocation(DatasetLocation location) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ParquetDatasetTypeProperties();
        }
        this.innerTypeProperties().withLocation(location);
        return this;
    }

    /**
     * Get the compressionCodec property: The data compressionCodec. Type: string (or Expression with resultType
     * string).
     * 
     * @return the compressionCodec value.
     */
    public Object compressionCodec() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compressionCodec();
    }

    /**
     * Set the compressionCodec property: The data compressionCodec. Type: string (or Expression with resultType
     * string).
     * 
     * @param compressionCodec the compressionCodec value to set.
     * @return the ParquetDataset object itself.
     */
    public ParquetDataset withCompressionCodec(Object compressionCodec) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ParquetDatasetTypeProperties();
        }
        this.innerTypeProperties().withCompressionCodec(compressionCodec);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() != null) {
            innerTypeProperties().validate();
        }
    }
}
