// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/**
 * PipelineExternalComputeScale properties for managed integration runtime.
 */
@Fluent
public final class PipelineExternalComputeScaleProperties {
    /*
     * Time to live (in minutes) setting of integration runtime which will execute pipeline and external activity.
     */
    @JsonProperty(value = "timeToLive")
    private Integer timeToLive;

    /*
     * Number of the pipeline nodes, which should be greater than 0 and less than 11.
     */
    @JsonProperty(value = "numberOfPipelineNodes")
    private Integer numberOfPipelineNodes;

    /*
     * Number of the the external nodes, which should be greater than 0 and less than 11.
     */
    @JsonProperty(value = "numberOfExternalNodes")
    private Integer numberOfExternalNodes;

    /*
     * PipelineExternalComputeScale properties for managed integration runtime.
     */
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of PipelineExternalComputeScaleProperties class.
     */
    public PipelineExternalComputeScaleProperties() {
    }

    /**
     * Get the timeToLive property: Time to live (in minutes) setting of integration runtime which will execute pipeline
     * and external activity.
     * 
     * @return the timeToLive value.
     */
    public Integer timeToLive() {
        return this.timeToLive;
    }

    /**
     * Set the timeToLive property: Time to live (in minutes) setting of integration runtime which will execute pipeline
     * and external activity.
     * 
     * @param timeToLive the timeToLive value to set.
     * @return the PipelineExternalComputeScaleProperties object itself.
     */
    public PipelineExternalComputeScaleProperties withTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    /**
     * Get the numberOfPipelineNodes property: Number of the pipeline nodes, which should be greater than 0 and less
     * than 11.
     * 
     * @return the numberOfPipelineNodes value.
     */
    public Integer numberOfPipelineNodes() {
        return this.numberOfPipelineNodes;
    }

    /**
     * Set the numberOfPipelineNodes property: Number of the pipeline nodes, which should be greater than 0 and less
     * than 11.
     * 
     * @param numberOfPipelineNodes the numberOfPipelineNodes value to set.
     * @return the PipelineExternalComputeScaleProperties object itself.
     */
    public PipelineExternalComputeScaleProperties withNumberOfPipelineNodes(Integer numberOfPipelineNodes) {
        this.numberOfPipelineNodes = numberOfPipelineNodes;
        return this;
    }

    /**
     * Get the numberOfExternalNodes property: Number of the the external nodes, which should be greater than 0 and less
     * than 11.
     * 
     * @return the numberOfExternalNodes value.
     */
    public Integer numberOfExternalNodes() {
        return this.numberOfExternalNodes;
    }

    /**
     * Set the numberOfExternalNodes property: Number of the the external nodes, which should be greater than 0 and less
     * than 11.
     * 
     * @param numberOfExternalNodes the numberOfExternalNodes value to set.
     * @return the PipelineExternalComputeScaleProperties object itself.
     */
    public PipelineExternalComputeScaleProperties withNumberOfExternalNodes(Integer numberOfExternalNodes) {
        this.numberOfExternalNodes = numberOfExternalNodes;
        return this;
    }

    /**
     * Get the additionalProperties property: PipelineExternalComputeScale properties for managed integration runtime.
     * 
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: PipelineExternalComputeScale properties for managed integration runtime.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the PipelineExternalComputeScaleProperties object itself.
     */
    public PipelineExternalComputeScaleProperties withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
