// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
 */
@Fluent
public final class PipelineFolder {
    /*
     * The name of the folder that this Pipeline is in.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * Creates an instance of PipelineFolder class.
     */
    public PipelineFolder() {
    }

    /**
     * Get the name property: The name of the folder that this Pipeline is in.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the folder that this Pipeline is in.
     * 
     * @param name the name value to set.
     * @return the PipelineFolder object itself.
     */
    public PipelineFolder withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
