// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Pipeline Policy.
 */
@Fluent
public final class PipelinePolicy {
    /*
     * Pipeline ElapsedTime Metric Policy.
     */
    @JsonProperty(value = "elapsedTimeMetric")
    private PipelineElapsedTimeMetricPolicy elapsedTimeMetric;

    /**
     * Creates an instance of PipelinePolicy class.
     */
    public PipelinePolicy() {
    }

    /**
     * Get the elapsedTimeMetric property: Pipeline ElapsedTime Metric Policy.
     * 
     * @return the elapsedTimeMetric value.
     */
    public PipelineElapsedTimeMetricPolicy elapsedTimeMetric() {
        return this.elapsedTimeMetric;
    }

    /**
     * Set the elapsedTimeMetric property: Pipeline ElapsedTime Metric Policy.
     * 
     * @param elapsedTimeMetric the elapsedTimeMetric value to set.
     * @return the PipelinePolicy object itself.
     */
    public PipelinePolicy withElapsedTimeMetric(PipelineElapsedTimeMetricPolicy elapsedTimeMetric) {
        this.elapsedTimeMetric = elapsedTimeMetric;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (elapsedTimeMetric() != null) {
            elapsedTimeMetric().validate();
        }
    }
}
