// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Provides entity name and id that started the pipeline run.
 */
@Immutable
public final class PipelineRunInvokedBy {
    /*
     * Name of the entity that started the pipeline run.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The ID of the entity that started the run.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The type of the entity that started the run.
     */
    @JsonProperty(value = "invokedByType", access = JsonProperty.Access.WRITE_ONLY)
    private String invokedByType;

    /*
     * The name of the pipeline that triggered the run, if any.
     */
    @JsonProperty(value = "pipelineName", access = JsonProperty.Access.WRITE_ONLY)
    private String pipelineName;

    /*
     * The run id of the pipeline that triggered the run, if any.
     */
    @JsonProperty(value = "pipelineRunId", access = JsonProperty.Access.WRITE_ONLY)
    private String pipelineRunId;

    /**
     * Creates an instance of PipelineRunInvokedBy class.
     */
    public PipelineRunInvokedBy() {
    }

    /**
     * Get the name property: Name of the entity that started the pipeline run.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: The ID of the entity that started the run.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the invokedByType property: The type of the entity that started the run.
     * 
     * @return the invokedByType value.
     */
    public String invokedByType() {
        return this.invokedByType;
    }

    /**
     * Get the pipelineName property: The name of the pipeline that triggered the run, if any.
     * 
     * @return the pipelineName value.
     */
    public String pipelineName() {
        return this.pipelineName;
    }

    /**
     * Get the pipelineRunId property: The run id of the pipeline that triggered the run, if any.
     * 
     * @return the pipelineRunId value.
     */
    public String pipelineRunId() {
        return this.pipelineRunId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
