// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.PostgreSqlV2LinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Linked service for PostgreSQLV2 data source.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = PostgreSqlV2LinkedService.class,
    visible = true)
@JsonTypeName("PostgreSqlV2")
@Fluent
public final class PostgreSqlV2LinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "PostgreSqlV2";

    /*
     * PostgreSQLV2 linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private PostgreSqlV2LinkedServiceTypeProperties innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();

    /**
     * Creates an instance of PostgreSqlV2LinkedService class.
     */
    public PostgreSqlV2LinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: PostgreSQLV2 linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private PostgreSqlV2LinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PostgreSqlV2LinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PostgreSqlV2LinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PostgreSqlV2LinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PostgreSqlV2LinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the server property: Server name for connection. Type: string.
     * 
     * @return the server value.
     */
    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    /**
     * Set the server property: Server name for connection. Type: string.
     * 
     * @param server the server value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    /**
     * Get the port property: The port for the connection. Type: integer.
     * 
     * @return the port value.
     */
    public Object port() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().port();
    }

    /**
     * Set the port property: The port for the connection. Type: integer.
     * 
     * @param port the port value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withPort(Object port) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPort(port);
        return this;
    }

    /**
     * Get the username property: Username for authentication. Type: string.
     * 
     * @return the username value.
     */
    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    /**
     * Set the username property: Username for authentication. Type: string.
     * 
     * @param username the username value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    /**
     * Get the database property: Database name for connection. Type: string.
     * 
     * @return the database value.
     */
    public Object database() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().database();
    }

    /**
     * Set the database property: Database name for connection. Type: string.
     * 
     * @param database the database value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withDatabase(Object database) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDatabase(database);
        return this;
    }

    /**
     * Get the sslMode property: SSL mode for connection. Type: integer. 0: disable, 1:allow, 2: prefer, 3: require, 4:
     * verify-ca, 5: verify-full. Type: integer.
     * 
     * @return the sslMode value.
     */
    public Object sslMode() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslMode();
    }

    /**
     * Set the sslMode property: SSL mode for connection. Type: integer. 0: disable, 1:allow, 2: prefer, 3: require, 4:
     * verify-ca, 5: verify-full. Type: integer.
     * 
     * @param sslMode the sslMode value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withSslMode(Object sslMode) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslMode(sslMode);
        return this;
    }

    /**
     * Get the schema property: Sets the schema search path. Type: string.
     * 
     * @return the schema value.
     */
    public Object schema() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().schema();
    }

    /**
     * Set the schema property: Sets the schema search path. Type: string.
     * 
     * @param schema the schema value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withSchema(Object schema) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSchema(schema);
        return this;
    }

    /**
     * Get the pooling property: Whether connection pooling should be used. Type: boolean.
     * 
     * @return the pooling value.
     */
    public Object pooling() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pooling();
    }

    /**
     * Set the pooling property: Whether connection pooling should be used. Type: boolean.
     * 
     * @param pooling the pooling value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withPooling(Object pooling) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPooling(pooling);
        return this;
    }

    /**
     * Get the connectionTimeout property: The time to wait (in seconds) while trying to establish a connection before
     * terminating the attempt and generating an error. Type: integer.
     * 
     * @return the connectionTimeout value.
     */
    public Object connectionTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionTimeout();
    }

    /**
     * Set the connectionTimeout property: The time to wait (in seconds) while trying to establish a connection before
     * terminating the attempt and generating an error. Type: integer.
     * 
     * @param connectionTimeout the connectionTimeout value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withConnectionTimeout(Object connectionTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionTimeout(connectionTimeout);
        return this;
    }

    /**
     * Get the commandTimeout property: The time to wait (in seconds) while trying to execute a command before
     * terminating the attempt and generating an error. Set to zero for infinity. Type: integer.
     * 
     * @return the commandTimeout value.
     */
    public Object commandTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().commandTimeout();
    }

    /**
     * Set the commandTimeout property: The time to wait (in seconds) while trying to execute a command before
     * terminating the attempt and generating an error. Set to zero for infinity. Type: integer.
     * 
     * @param commandTimeout the commandTimeout value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withCommandTimeout(Object commandTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCommandTimeout(commandTimeout);
        return this;
    }

    /**
     * Get the trustServerCertificate property: Whether to trust the server certificate without validating it. Type:
     * boolean.
     * 
     * @return the trustServerCertificate value.
     */
    public Object trustServerCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustServerCertificate();
    }

    /**
     * Set the trustServerCertificate property: Whether to trust the server certificate without validating it. Type:
     * boolean.
     * 
     * @param trustServerCertificate the trustServerCertificate value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withTrustServerCertificate(Object trustServerCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustServerCertificate(trustServerCertificate);
        return this;
    }

    /**
     * Get the sslCertificate property: Location of a client certificate to be sent to the server. Type: string.
     * 
     * @return the sslCertificate value.
     */
    public Object sslCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslCertificate();
    }

    /**
     * Set the sslCertificate property: Location of a client certificate to be sent to the server. Type: string.
     * 
     * @param sslCertificate the sslCertificate value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withSslCertificate(Object sslCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslCertificate(sslCertificate);
        return this;
    }

    /**
     * Get the sslKey property: Location of a client key for a client certificate to be sent to the server. Type:
     * string.
     * 
     * @return the sslKey value.
     */
    public Object sslKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslKey();
    }

    /**
     * Set the sslKey property: Location of a client key for a client certificate to be sent to the server. Type:
     * string.
     * 
     * @param sslKey the sslKey value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withSslKey(Object sslKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslKey(sslKey);
        return this;
    }

    /**
     * Get the sslPassword property: Password for a key for a client certificate. Type: string.
     * 
     * @return the sslPassword value.
     */
    public Object sslPassword() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslPassword();
    }

    /**
     * Set the sslPassword property: Password for a key for a client certificate. Type: string.
     * 
     * @param sslPassword the sslPassword value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withSslPassword(Object sslPassword) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslPassword(sslPassword);
        return this;
    }

    /**
     * Get the readBufferSize property: Determines the size of the internal buffer uses when reading. Increasing may
     * improve performance if transferring large values from the database. Type: integer.
     * 
     * @return the readBufferSize value.
     */
    public Object readBufferSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().readBufferSize();
    }

    /**
     * Set the readBufferSize property: Determines the size of the internal buffer uses when reading. Increasing may
     * improve performance if transferring large values from the database. Type: integer.
     * 
     * @param readBufferSize the readBufferSize value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withReadBufferSize(Object readBufferSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withReadBufferSize(readBufferSize);
        return this;
    }

    /**
     * Get the logParameters property: When enabled, parameter values are logged when commands are executed. Type:
     * boolean.
     * 
     * @return the logParameters value.
     */
    public Object logParameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logParameters();
    }

    /**
     * Set the logParameters property: When enabled, parameter values are logged when commands are executed. Type:
     * boolean.
     * 
     * @param logParameters the logParameters value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withLogParameters(Object logParameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLogParameters(logParameters);
        return this;
    }

    /**
     * Get the timezone property: Gets or sets the session timezone. Type: string.
     * 
     * @return the timezone value.
     */
    public Object timezone() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().timezone();
    }

    /**
     * Set the timezone property: Gets or sets the session timezone. Type: string.
     * 
     * @param timezone the timezone value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withTimezone(Object timezone) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTimezone(timezone);
        return this;
    }

    /**
     * Get the encoding property: Gets or sets the .NET encoding that will be used to encode/decode PostgreSQL string
     * data. Type: string.
     * 
     * @return the encoding value.
     */
    public Object encoding() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encoding();
    }

    /**
     * Set the encoding property: Gets or sets the .NET encoding that will be used to encode/decode PostgreSQL string
     * data. Type: string.
     * 
     * @param encoding the encoding value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withEncoding(Object encoding) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncoding(encoding);
        return this;
    }

    /**
     * Get the password property: The Azure key vault secret reference of password in connection string. Type: string.
     * 
     * @return the password value.
     */
    public AzureKeyVaultSecretReference password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    /**
     * Set the password property: The Azure key vault secret reference of password in connection string. Type: string.
     * 
     * @param password the password value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withPassword(AzureKeyVaultSecretReference password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the PostgreSqlV2LinkedService object itself.
     */
    public PostgreSqlV2LinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model PostgreSqlV2LinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PostgreSqlV2LinkedService.class);
}
