// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Power query sink.
 */
@Fluent
public final class PowerQuerySink extends DataFlowSink {
    /*
     * sink script.
     */
    @JsonProperty(value = "script")
    private String script;

    /**
     * Creates an instance of PowerQuerySink class.
     */
    public PowerQuerySink() {
    }

    /**
     * Get the script property: sink script.
     * 
     * @return the script value.
     */
    public String script() {
        return this.script;
    }

    /**
     * Set the script property: sink script.
     * 
     * @param script the script value to set.
     * @return the PowerQuerySink object itself.
     */
    public PowerQuerySink withScript(String script) {
        this.script = script;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PowerQuerySink withSchemaLinkedService(LinkedServiceReference schemaLinkedService) {
        super.withSchemaLinkedService(schemaLinkedService);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PowerQuerySink withRejectedDataLinkedService(LinkedServiceReference rejectedDataLinkedService) {
        super.withRejectedDataLinkedService(rejectedDataLinkedService);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PowerQuerySink withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PowerQuerySink withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PowerQuerySink withDataset(DatasetReference dataset) {
        super.withDataset(dataset);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PowerQuerySink withLinkedService(LinkedServiceReference linkedService) {
        super.withLinkedService(linkedService);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PowerQuerySink withFlowlet(DataFlowReference flowlet) {
        super.withFlowlet(flowlet);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
