// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.PrivateEndpointConnectionResourceInner;

/**
 * An immutable client-side representation of PrivateEndpointConnectionResource.
 */
public interface PrivateEndpointConnectionResource {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the properties property: Core resource properties.
     * 
     * @return the properties value.
     */
    RemotePrivateEndpointConnection properties();

    /**
     * Gets the name property: The resource name.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The resource type.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the etag property: Etag identifies change in the resource.
     * 
     * @return the etag value.
     */
    String etag();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.datafactory.fluent.models.PrivateEndpointConnectionResourceInner object.
     * 
     * @return the inner object.
     */
    PrivateEndpointConnectionResourceInner innerModel();

    /**
     * The entirety of the PrivateEndpointConnectionResource definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The PrivateEndpointConnectionResource definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the PrivateEndpointConnectionResource definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the PrivateEndpointConnectionResource definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, factoryName.
             * 
             * @param resourceGroupName The resource group name.
             * @param factoryName The factory name.
             * @return the next definition stage.
             */
            WithCreate withExistingFactory(String resourceGroupName, String factoryName);
        }

        /**
         * The stage of the PrivateEndpointConnectionResource definition which contains all the minimum required
         * properties for the resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithProperties, DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            PrivateEndpointConnectionResource create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            PrivateEndpointConnectionResource create(Context context);
        }

        /**
         * The stage of the PrivateEndpointConnectionResource definition allowing to specify properties.
         */
        interface WithProperties {
            /**
             * Specifies the properties property: Core resource properties.
             * 
             * @param properties Core resource properties.
             * @return the next definition stage.
             */
            WithCreate withProperties(PrivateLinkConnectionApprovalRequest properties);
        }

        /**
         * The stage of the PrivateEndpointConnectionResource definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the private endpoint connection entity. Should only be specified
             * for update, for which it should match existing entity or can be * for unconditional update..
             * 
             * @param ifMatch ETag of the private endpoint connection entity. Should only be specified for update, for
             * which it should match existing entity or can be * for unconditional update.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the PrivateEndpointConnectionResource resource.
     * 
     * @return the stage of resource update.
     */
    PrivateEndpointConnectionResource.Update update();

    /**
     * The template for PrivateEndpointConnectionResource update.
     */
    interface Update extends UpdateStages.WithProperties, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        PrivateEndpointConnectionResource apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        PrivateEndpointConnectionResource apply(Context context);
    }

    /**
     * The PrivateEndpointConnectionResource update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the PrivateEndpointConnectionResource update allowing to specify properties.
         */
        interface WithProperties {
            /**
             * Specifies the properties property: Core resource properties.
             * 
             * @param properties Core resource properties.
             * @return the next definition stage.
             */
            Update withProperties(PrivateLinkConnectionApprovalRequest properties);
        }

        /**
         * The stage of the PrivateEndpointConnectionResource update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the private endpoint connection entity. Should only be specified
             * for update, for which it should match existing entity or can be * for unconditional update..
             * 
             * @param ifMatch ETag of the private endpoint connection entity. Should only be specified for update, for
             * which it should match existing entity or can be * for unconditional update.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    PrivateEndpointConnectionResource refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    PrivateEndpointConnectionResource refresh(Context context);
}
