// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/**
 * The recurrence schedule occurrence.
 */
@Fluent
public final class RecurrenceScheduleOccurrence {
    /*
     * The day of the week.
     */
    @JsonProperty(value = "day")
    private DayOfWeek day;

    /*
     * The occurrence.
     */
    @JsonProperty(value = "occurrence")
    private Integer occurrence;

    /*
     * The recurrence schedule occurrence.
     */
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of RecurrenceScheduleOccurrence class.
     */
    public RecurrenceScheduleOccurrence() {
    }

    /**
     * Get the day property: The day of the week.
     * 
     * @return the day value.
     */
    public DayOfWeek day() {
        return this.day;
    }

    /**
     * Set the day property: The day of the week.
     * 
     * @param day the day value to set.
     * @return the RecurrenceScheduleOccurrence object itself.
     */
    public RecurrenceScheduleOccurrence withDay(DayOfWeek day) {
        this.day = day;
        return this;
    }

    /**
     * Get the occurrence property: The occurrence.
     * 
     * @return the occurrence value.
     */
    public Integer occurrence() {
        return this.occurrence;
    }

    /**
     * Set the occurrence property: The occurrence.
     * 
     * @param occurrence the occurrence value to set.
     * @return the RecurrenceScheduleOccurrence object itself.
     */
    public RecurrenceScheduleOccurrence withOccurrence(Integer occurrence) {
        this.occurrence = occurrence;
        return this;
    }

    /**
     * Get the additionalProperties property: The recurrence schedule occurrence.
     * 
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: The recurrence schedule occurrence.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the RecurrenceScheduleOccurrence object itself.
     */
    public RecurrenceScheduleOccurrence withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
