// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/**
 * Redirect incompatible row settings.
 */
@Fluent
public final class RedirectIncompatibleRowSettings {
    /*
     * Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked service used for redirecting incompatible row. Must be specified if redirectIncompatibleRowSettings is specified. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "linkedServiceName", required = true)
    private Object linkedServiceName;

    /*
     * The path for storing the redirect incompatible row data. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "path")
    private Object path;

    /*
     * Redirect incompatible row settings
     */
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of RedirectIncompatibleRowSettings class.
     */
    public RedirectIncompatibleRowSettings() {
    }

    /**
     * Get the linkedServiceName property: Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked
     * service used for redirecting incompatible row. Must be specified if redirectIncompatibleRowSettings is specified.
     * Type: string (or Expression with resultType string).
     * 
     * @return the linkedServiceName value.
     */
    public Object linkedServiceName() {
        return this.linkedServiceName;
    }

    /**
     * Set the linkedServiceName property: Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked
     * service used for redirecting incompatible row. Must be specified if redirectIncompatibleRowSettings is specified.
     * Type: string (or Expression with resultType string).
     * 
     * @param linkedServiceName the linkedServiceName value to set.
     * @return the RedirectIncompatibleRowSettings object itself.
     */
    public RedirectIncompatibleRowSettings withLinkedServiceName(Object linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    /**
     * Get the path property: The path for storing the redirect incompatible row data. Type: string (or Expression with
     * resultType string).
     * 
     * @return the path value.
     */
    public Object path() {
        return this.path;
    }

    /**
     * Set the path property: The path for storing the redirect incompatible row data. Type: string (or Expression with
     * resultType string).
     * 
     * @param path the path value to set.
     * @return the RedirectIncompatibleRowSettings object itself.
     */
    public RedirectIncompatibleRowSettings withPath(Object path) {
        this.path = path;
        return this;
    }

    /**
     * Get the additionalProperties property: Redirect incompatible row settings.
     * 
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Redirect incompatible row settings.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the RedirectIncompatibleRowSettings object itself.
     */
    public RedirectIncompatibleRowSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (linkedServiceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property linkedServiceName in model RedirectIncompatibleRowSettings"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedirectIncompatibleRowSettings.class);
}
