// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.RerunTumblingWindowTriggerTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Trigger that schedules pipeline reruns for all fixed time interval windows from a requested start time to requested
 * end time.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = RerunTumblingWindowTrigger.class,
    visible = true)
@JsonTypeName("RerunTumblingWindowTrigger")
@Fluent
public final class RerunTumblingWindowTrigger extends Trigger {
    /*
     * Trigger type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "RerunTumblingWindowTrigger";

    /*
     * Rerun Trigger properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private RerunTumblingWindowTriggerTypeProperties innerTypeProperties
        = new RerunTumblingWindowTriggerTypeProperties();

    /**
     * Creates an instance of RerunTumblingWindowTrigger class.
     */
    public RerunTumblingWindowTrigger() {
    }

    /**
     * Get the type property: Trigger type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Rerun Trigger properties.
     * 
     * @return the innerTypeProperties value.
     */
    private RerunTumblingWindowTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RerunTumblingWindowTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RerunTumblingWindowTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the parentTrigger property: The parent trigger reference.
     * 
     * @return the parentTrigger value.
     */
    public Object parentTrigger() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().parentTrigger();
    }

    /**
     * Set the parentTrigger property: The parent trigger reference.
     * 
     * @param parentTrigger the parentTrigger value to set.
     * @return the RerunTumblingWindowTrigger object itself.
     */
    public RerunTumblingWindowTrigger withParentTrigger(Object parentTrigger) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RerunTumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withParentTrigger(parentTrigger);
        return this;
    }

    /**
     * Get the requestedStartTime property: The start time for the time period for which restatement is initiated. Only
     * UTC time is currently supported.
     * 
     * @return the requestedStartTime value.
     */
    public OffsetDateTime requestedStartTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().requestedStartTime();
    }

    /**
     * Set the requestedStartTime property: The start time for the time period for which restatement is initiated. Only
     * UTC time is currently supported.
     * 
     * @param requestedStartTime the requestedStartTime value to set.
     * @return the RerunTumblingWindowTrigger object itself.
     */
    public RerunTumblingWindowTrigger withRequestedStartTime(OffsetDateTime requestedStartTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RerunTumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withRequestedStartTime(requestedStartTime);
        return this;
    }

    /**
     * Get the requestedEndTime property: The end time for the time period for which restatement is initiated. Only UTC
     * time is currently supported.
     * 
     * @return the requestedEndTime value.
     */
    public OffsetDateTime requestedEndTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().requestedEndTime();
    }

    /**
     * Set the requestedEndTime property: The end time for the time period for which restatement is initiated. Only UTC
     * time is currently supported.
     * 
     * @param requestedEndTime the requestedEndTime value to set.
     * @return the RerunTumblingWindowTrigger object itself.
     */
    public RerunTumblingWindowTrigger withRequestedEndTime(OffsetDateTime requestedEndTime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RerunTumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withRequestedEndTime(requestedEndTime);
        return this;
    }

    /**
     * Get the rerunConcurrency property: The max number of parallel time windows (ready for execution) for which a
     * rerun is triggered.
     * 
     * @return the rerunConcurrency value.
     */
    public int rerunConcurrency() {
        return this.innerTypeProperties() == null ? 0 : this.innerTypeProperties().rerunConcurrency();
    }

    /**
     * Set the rerunConcurrency property: The max number of parallel time windows (ready for execution) for which a
     * rerun is triggered.
     * 
     * @param rerunConcurrency the rerunConcurrency value to set.
     * @return the RerunTumblingWindowTrigger object itself.
     */
    public RerunTumblingWindowTrigger withRerunConcurrency(int rerunConcurrency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RerunTumblingWindowTriggerTypeProperties();
        }
        this.innerTypeProperties().withRerunConcurrency(rerunConcurrency);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model RerunTumblingWindowTrigger"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RerunTumblingWindowTrigger.class);
}
