// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.fluent.models.RestResourceDatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * A Rest service dataset.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = RestResourceDataset.class, visible = true)
@JsonTypeName("RestResource")
@Fluent
public final class RestResourceDataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "RestResource";

    /*
     * Properties specific to this dataset type.
     */
    @JsonProperty(value = "typeProperties")
    private RestResourceDatasetTypeProperties innerTypeProperties;

    /**
     * Creates an instance of RestResourceDataset class.
     */
    public RestResourceDataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Properties specific to this dataset type.
     * 
     * @return the innerTypeProperties value.
     */
    private RestResourceDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestResourceDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestResourceDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestResourceDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestResourceDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestResourceDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestResourceDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestResourceDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the relativeUrl property: The relative URL to the resource that the RESTful API provides. Type: string (or
     * Expression with resultType string).
     * 
     * @return the relativeUrl value.
     */
    public Object relativeUrl() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().relativeUrl();
    }

    /**
     * Set the relativeUrl property: The relative URL to the resource that the RESTful API provides. Type: string (or
     * Expression with resultType string).
     * 
     * @param relativeUrl the relativeUrl value to set.
     * @return the RestResourceDataset object itself.
     */
    public RestResourceDataset withRelativeUrl(Object relativeUrl) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withRelativeUrl(relativeUrl);
        return this;
    }

    /**
     * Get the requestMethod property: The HTTP method used to call the RESTful API. The default is GET. Type: string
     * (or Expression with resultType string).
     * 
     * @return the requestMethod value.
     */
    public Object requestMethod() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().requestMethod();
    }

    /**
     * Set the requestMethod property: The HTTP method used to call the RESTful API. The default is GET. Type: string
     * (or Expression with resultType string).
     * 
     * @param requestMethod the requestMethod value to set.
     * @return the RestResourceDataset object itself.
     */
    public RestResourceDataset withRequestMethod(Object requestMethod) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withRequestMethod(requestMethod);
        return this;
    }

    /**
     * Get the requestBody property: The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or
     * Expression with resultType string).
     * 
     * @return the requestBody value.
     */
    public Object requestBody() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().requestBody();
    }

    /**
     * Set the requestBody property: The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or
     * Expression with resultType string).
     * 
     * @param requestBody the requestBody value to set.
     * @return the RestResourceDataset object itself.
     */
    public RestResourceDataset withRequestBody(Object requestBody) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withRequestBody(requestBody);
        return this;
    }

    /**
     * Get the additionalHeaders property: The additional HTTP headers in the request to the RESTful API.
     * 
     * @return the additionalHeaders value.
     */
    public Map<String, Object> additionalHeaders() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().additionalHeaders();
    }

    /**
     * Set the additionalHeaders property: The additional HTTP headers in the request to the RESTful API.
     * 
     * @param additionalHeaders the additionalHeaders value to set.
     * @return the RestResourceDataset object itself.
     */
    public RestResourceDataset withAdditionalHeaders(Map<String, Object> additionalHeaders) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withAdditionalHeaders(additionalHeaders);
        return this;
    }

    /**
     * Get the paginationRules property: The pagination rules to compose next page requests.
     * 
     * @return the paginationRules value.
     */
    public Map<String, Object> paginationRules() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().paginationRules();
    }

    /**
     * Set the paginationRules property: The pagination rules to compose next page requests.
     * 
     * @param paginationRules the paginationRules value to set.
     * @return the RestResourceDataset object itself.
     */
    public RestResourceDataset withPaginationRules(Map<String, Object> paginationRules) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withPaginationRules(paginationRules);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() != null) {
            innerTypeProperties().validate();
        }
    }
}
