// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.fluent.models.SalesforceObjectDatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * The Salesforce object dataset.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = SalesforceObjectDataset.class,
    visible = true)
@JsonTypeName("SalesforceObject")
@Fluent
public final class SalesforceObjectDataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SalesforceObject";

    /*
     * Salesforce object dataset properties.
     */
    @JsonProperty(value = "typeProperties")
    private SalesforceObjectDatasetTypeProperties innerTypeProperties;

    /**
     * Creates an instance of SalesforceObjectDataset class.
     */
    public SalesforceObjectDataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Salesforce object dataset properties.
     * 
     * @return the innerTypeProperties value.
     */
    private SalesforceObjectDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceObjectDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceObjectDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceObjectDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceObjectDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceObjectDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceObjectDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceObjectDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the objectApiName property: The Salesforce object API name. Type: string (or Expression with resultType
     * string).
     * 
     * @return the objectApiName value.
     */
    public Object objectApiName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().objectApiName();
    }

    /**
     * Set the objectApiName property: The Salesforce object API name. Type: string (or Expression with resultType
     * string).
     * 
     * @param objectApiName the objectApiName value to set.
     * @return the SalesforceObjectDataset object itself.
     */
    public SalesforceObjectDataset withObjectApiName(Object objectApiName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SalesforceObjectDatasetTypeProperties();
        }
        this.innerTypeProperties().withObjectApiName(objectApiName);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() != null) {
            innerTypeProperties().validate();
        }
    }
}
