// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A copy activity Salesforce Service Cloud V2 sink.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = SalesforceServiceCloudV2Sink.class,
    visible = true)
@JsonTypeName("SalesforceServiceCloudV2Sink")
@Fluent
public final class SalesforceServiceCloudV2Sink extends CopySink {
    /*
     * Copy sink type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SalesforceServiceCloudV2Sink";

    /*
     * The write behavior for the operation. Default is Insert.
     */
    @JsonProperty(value = "writeBehavior")
    private SalesforceV2SinkWriteBehavior writeBehavior;

    /*
     * The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "externalIdFieldName")
    private Object externalIdFieldName;

    /*
     * The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave the data in the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert operation, versus ADF will update the data in the destination object to NULL when doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "ignoreNullValues")
    private Object ignoreNullValues;

    /**
     * Creates an instance of SalesforceServiceCloudV2Sink class.
     */
    public SalesforceServiceCloudV2Sink() {
    }

    /**
     * Get the type property: Copy sink type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the writeBehavior property: The write behavior for the operation. Default is Insert.
     * 
     * @return the writeBehavior value.
     */
    public SalesforceV2SinkWriteBehavior writeBehavior() {
        return this.writeBehavior;
    }

    /**
     * Set the writeBehavior property: The write behavior for the operation. Default is Insert.
     * 
     * @param writeBehavior the writeBehavior value to set.
     * @return the SalesforceServiceCloudV2Sink object itself.
     */
    public SalesforceServiceCloudV2Sink withWriteBehavior(SalesforceV2SinkWriteBehavior writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    /**
     * Get the externalIdFieldName property: The name of the external ID field for upsert operation. Default value is
     * 'Id' column. Type: string (or Expression with resultType string).
     * 
     * @return the externalIdFieldName value.
     */
    public Object externalIdFieldName() {
        return this.externalIdFieldName;
    }

    /**
     * Set the externalIdFieldName property: The name of the external ID field for upsert operation. Default value is
     * 'Id' column. Type: string (or Expression with resultType string).
     * 
     * @param externalIdFieldName the externalIdFieldName value to set.
     * @return the SalesforceServiceCloudV2Sink object itself.
     */
    public SalesforceServiceCloudV2Sink withExternalIdFieldName(Object externalIdFieldName) {
        this.externalIdFieldName = externalIdFieldName;
        return this;
    }

    /**
     * Get the ignoreNullValues property: The flag indicating whether or not to ignore null values from input dataset
     * (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave
     * the data in the destination object unchanged when doing upsert/update operation and insert defined default value
     * when doing insert operation, versus ADF will update the data in the destination object to NULL when doing
     * upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with
     * resultType boolean).
     * 
     * @return the ignoreNullValues value.
     */
    public Object ignoreNullValues() {
        return this.ignoreNullValues;
    }

    /**
     * Set the ignoreNullValues property: The flag indicating whether or not to ignore null values from input dataset
     * (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave
     * the data in the destination object unchanged when doing upsert/update operation and insert defined default value
     * when doing insert operation, versus ADF will update the data in the destination object to NULL when doing
     * upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with
     * resultType boolean).
     * 
     * @param ignoreNullValues the ignoreNullValues value to set.
     * @return the SalesforceServiceCloudV2Sink object itself.
     */
    public SalesforceServiceCloudV2Sink withIgnoreNullValues(Object ignoreNullValues) {
        this.ignoreNullValues = ignoreNullValues;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceServiceCloudV2Sink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceServiceCloudV2Sink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceServiceCloudV2Sink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceServiceCloudV2Sink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceServiceCloudV2Sink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceServiceCloudV2Sink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
