// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A copy activity Salesforce Service Cloud V2 source.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = SalesforceServiceCloudV2Source.class,
    visible = true)
@JsonTypeName("SalesforceServiceCloudV2Source")
@Fluent
public final class SalesforceServiceCloudV2Source extends CopySource {
    /*
     * Copy source type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SalesforceServiceCloudV2Source";

    /*
     * Database query. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "SOQLQuery")
    private Object soqlQuery;

    /*
     * This property control whether query result contains Deleted objects. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "includeDeletedObjects")
    private Object includeDeletedObjects;

    /*
     * Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JsonProperty(value = "additionalColumns")
    private Object additionalColumns;

    /**
     * Creates an instance of SalesforceServiceCloudV2Source class.
     */
    public SalesforceServiceCloudV2Source() {
    }

    /**
     * Get the type property: Copy source type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the soqlQuery property: Database query. Type: string (or Expression with resultType string).
     * 
     * @return the soqlQuery value.
     */
    public Object soqlQuery() {
        return this.soqlQuery;
    }

    /**
     * Set the soqlQuery property: Database query. Type: string (or Expression with resultType string).
     * 
     * @param soqlQuery the soqlQuery value to set.
     * @return the SalesforceServiceCloudV2Source object itself.
     */
    public SalesforceServiceCloudV2Source withSoqlQuery(Object soqlQuery) {
        this.soqlQuery = soqlQuery;
        return this;
    }

    /**
     * Get the includeDeletedObjects property: This property control whether query result contains Deleted objects.
     * Default is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the includeDeletedObjects value.
     */
    public Object includeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    /**
     * Set the includeDeletedObjects property: This property control whether query result contains Deleted objects.
     * Default is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @param includeDeletedObjects the includeDeletedObjects value to set.
     * @return the SalesforceServiceCloudV2Source object itself.
     */
    public SalesforceServiceCloudV2Source withIncludeDeletedObjects(Object includeDeletedObjects) {
        this.includeDeletedObjects = includeDeletedObjects;
        return this;
    }

    /**
     * Get the additionalColumns property: Specifies the additional columns to be added to source data. Type: array of
     * objects(AdditionalColumns) (or Expression with resultType array of objects).
     * 
     * @return the additionalColumns value.
     */
    public Object additionalColumns() {
        return this.additionalColumns;
    }

    /**
     * Set the additionalColumns property: Specifies the additional columns to be added to source data. Type: array of
     * objects(AdditionalColumns) (or Expression with resultType array of objects).
     * 
     * @param additionalColumns the additionalColumns value to set.
     * @return the SalesforceServiceCloudV2Source object itself.
     */
    public SalesforceServiceCloudV2Source withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceServiceCloudV2Source withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceServiceCloudV2Source withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceServiceCloudV2Source withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceServiceCloudV2Source withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
