// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A copy activity Salesforce V2 source.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = SalesforceV2Source.class, visible = true)
@JsonTypeName("SalesforceV2Source")
@Fluent
public final class SalesforceV2Source extends TabularSource {
    /*
     * Copy source type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SalesforceV2Source";

    /*
     * Database query. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "SOQLQuery")
    private Object soqlQuery;

    /*
     * This property control whether query result contains Deleted objects. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "includeDeletedObjects")
    private Object includeDeletedObjects;

    /**
     * Creates an instance of SalesforceV2Source class.
     */
    public SalesforceV2Source() {
    }

    /**
     * Get the type property: Copy source type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the soqlQuery property: Database query. Type: string (or Expression with resultType string).
     * 
     * @return the soqlQuery value.
     */
    public Object soqlQuery() {
        return this.soqlQuery;
    }

    /**
     * Set the soqlQuery property: Database query. Type: string (or Expression with resultType string).
     * 
     * @param soqlQuery the soqlQuery value to set.
     * @return the SalesforceV2Source object itself.
     */
    public SalesforceV2Source withSoqlQuery(Object soqlQuery) {
        this.soqlQuery = soqlQuery;
        return this;
    }

    /**
     * Get the includeDeletedObjects property: This property control whether query result contains Deleted objects.
     * Default is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the includeDeletedObjects value.
     */
    public Object includeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    /**
     * Set the includeDeletedObjects property: This property control whether query result contains Deleted objects.
     * Default is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @param includeDeletedObjects the includeDeletedObjects value to set.
     * @return the SalesforceV2Source object itself.
     */
    public SalesforceV2Source withIncludeDeletedObjects(Object includeDeletedObjects) {
        this.includeDeletedObjects = includeDeletedObjects;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceV2Source withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceV2Source withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceV2Source withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceV2Source withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceV2Source withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SalesforceV2Source withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
