// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The authentication type to be used to connect to the SAP HANA server.
 */
public final class SapHanaAuthenticationType extends ExpandableStringEnum<SapHanaAuthenticationType> {
    /**
     * Static value Basic for SapHanaAuthenticationType.
     */
    public static final SapHanaAuthenticationType BASIC = fromString("Basic");

    /**
     * Static value Windows for SapHanaAuthenticationType.
     */
    public static final SapHanaAuthenticationType WINDOWS = fromString("Windows");

    /**
     * Creates a new instance of SapHanaAuthenticationType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SapHanaAuthenticationType() {
    }

    /**
     * Creates or finds a SapHanaAuthenticationType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SapHanaAuthenticationType.
     */
    @JsonCreator
    public static SapHanaAuthenticationType fromString(String name) {
        return fromString(name, SapHanaAuthenticationType.class);
    }

    /**
     * Gets known SapHanaAuthenticationType values.
     * 
     * @return known SapHanaAuthenticationType values.
     */
    public static Collection<SapHanaAuthenticationType> values() {
        return values(SapHanaAuthenticationType.class);
    }
}
