// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.SapOdpLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * SAP ODP Linked Service.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = SapOdpLinkedService.class, visible = true)
@JsonTypeName("SapOdp")
@Fluent
public final class SapOdpLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SapOdp";

    /*
     * Properties specific to SAP ODP linked service type.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private SapOdpLinkedServiceTypeProperties innerTypeProperties = new SapOdpLinkedServiceTypeProperties();

    /**
     * Creates an instance of SapOdpLinkedService class.
     */
    public SapOdpLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Properties specific to SAP ODP linked service type.
     * 
     * @return the innerTypeProperties value.
     */
    private SapOdpLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapOdpLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapOdpLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapOdpLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapOdpLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the server property: Host name of the SAP instance where the table is located. Type: string (or Expression
     * with resultType string).
     * 
     * @return the server value.
     */
    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    /**
     * Set the server property: Host name of the SAP instance where the table is located. Type: string (or Expression
     * with resultType string).
     * 
     * @param server the server value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    /**
     * Get the systemNumber property: System number of the SAP system where the table is located. (Usually a two-digit
     * decimal number represented as a string.) Type: string (or Expression with resultType string).
     * 
     * @return the systemNumber value.
     */
    public Object systemNumber() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().systemNumber();
    }

    /**
     * Set the systemNumber property: System number of the SAP system where the table is located. (Usually a two-digit
     * decimal number represented as a string.) Type: string (or Expression with resultType string).
     * 
     * @param systemNumber the systemNumber value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withSystemNumber(Object systemNumber) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSystemNumber(systemNumber);
        return this;
    }

    /**
     * Get the clientId property: Client ID of the client on the SAP system where the table is located. (Usually a
     * three-digit decimal number represented as a string) Type: string (or Expression with resultType string).
     * 
     * @return the clientId value.
     */
    public Object clientId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientId();
    }

    /**
     * Set the clientId property: Client ID of the client on the SAP system where the table is located. (Usually a
     * three-digit decimal number represented as a string) Type: string (or Expression with resultType string).
     * 
     * @param clientId the clientId value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withClientId(Object clientId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientId(clientId);
        return this;
    }

    /**
     * Get the language property: Language of the SAP system where the table is located. The default value is EN. Type:
     * string (or Expression with resultType string).
     * 
     * @return the language value.
     */
    public Object language() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().language();
    }

    /**
     * Set the language property: Language of the SAP system where the table is located. The default value is EN. Type:
     * string (or Expression with resultType string).
     * 
     * @param language the language value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withLanguage(Object language) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLanguage(language);
        return this;
    }

    /**
     * Get the systemId property: SystemID of the SAP system where the table is located. Type: string (or Expression
     * with resultType string).
     * 
     * @return the systemId value.
     */
    public Object systemId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().systemId();
    }

    /**
     * Set the systemId property: SystemID of the SAP system where the table is located. Type: string (or Expression
     * with resultType string).
     * 
     * @param systemId the systemId value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withSystemId(Object systemId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSystemId(systemId);
        return this;
    }

    /**
     * Get the username property: Username to access the SAP server where the table is located. Type: string (or
     * Expression with resultType string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    /**
     * Set the username property: Username to access the SAP server where the table is located. Type: string (or
     * Expression with resultType string).
     * 
     * @param username the username value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    /**
     * Get the password property: Password to access the SAP server where the table is located.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    /**
     * Set the password property: Password to access the SAP server where the table is located.
     * 
     * @param password the password value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    /**
     * Get the messageServer property: The hostname of the SAP Message Server. Type: string (or Expression with
     * resultType string).
     * 
     * @return the messageServer value.
     */
    public Object messageServer() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().messageServer();
    }

    /**
     * Set the messageServer property: The hostname of the SAP Message Server. Type: string (or Expression with
     * resultType string).
     * 
     * @param messageServer the messageServer value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withMessageServer(Object messageServer) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMessageServer(messageServer);
        return this;
    }

    /**
     * Get the messageServerService property: The service name or port number of the Message Server. Type: string (or
     * Expression with resultType string).
     * 
     * @return the messageServerService value.
     */
    public Object messageServerService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().messageServerService();
    }

    /**
     * Set the messageServerService property: The service name or port number of the Message Server. Type: string (or
     * Expression with resultType string).
     * 
     * @param messageServerService the messageServerService value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withMessageServerService(Object messageServerService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMessageServerService(messageServerService);
        return this;
    }

    /**
     * Get the sncMode property: SNC activation indicator to access the SAP server where the table is located. Must be
     * either 0 (off) or 1 (on). Type: string (or Expression with resultType string).
     * 
     * @return the sncMode value.
     */
    public Object sncMode() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sncMode();
    }

    /**
     * Set the sncMode property: SNC activation indicator to access the SAP server where the table is located. Must be
     * either 0 (off) or 1 (on). Type: string (or Expression with resultType string).
     * 
     * @param sncMode the sncMode value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withSncMode(Object sncMode) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSncMode(sncMode);
        return this;
    }

    /**
     * Get the sncMyName property: Initiator's SNC name to access the SAP server where the table is located. Type:
     * string (or Expression with resultType string).
     * 
     * @return the sncMyName value.
     */
    public Object sncMyName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sncMyName();
    }

    /**
     * Set the sncMyName property: Initiator's SNC name to access the SAP server where the table is located. Type:
     * string (or Expression with resultType string).
     * 
     * @param sncMyName the sncMyName value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withSncMyName(Object sncMyName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSncMyName(sncMyName);
        return this;
    }

    /**
     * Get the sncPartnerName property: Communication partner's SNC name to access the SAP server where the table is
     * located. Type: string (or Expression with resultType string).
     * 
     * @return the sncPartnerName value.
     */
    public Object sncPartnerName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sncPartnerName();
    }

    /**
     * Set the sncPartnerName property: Communication partner's SNC name to access the SAP server where the table is
     * located. Type: string (or Expression with resultType string).
     * 
     * @param sncPartnerName the sncPartnerName value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withSncPartnerName(Object sncPartnerName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSncPartnerName(sncPartnerName);
        return this;
    }

    /**
     * Get the sncLibraryPath property: External security product's library to access the SAP server where the table is
     * located. Type: string (or Expression with resultType string).
     * 
     * @return the sncLibraryPath value.
     */
    public Object sncLibraryPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sncLibraryPath();
    }

    /**
     * Set the sncLibraryPath property: External security product's library to access the SAP server where the table is
     * located. Type: string (or Expression with resultType string).
     * 
     * @param sncLibraryPath the sncLibraryPath value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withSncLibraryPath(Object sncLibraryPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSncLibraryPath(sncLibraryPath);
        return this;
    }

    /**
     * Get the sncQop property: SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string (or
     * Expression with resultType string).
     * 
     * @return the sncQop value.
     */
    public Object sncQop() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sncQop();
    }

    /**
     * Set the sncQop property: SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string (or
     * Expression with resultType string).
     * 
     * @param sncQop the sncQop value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withSncQop(Object sncQop) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSncQop(sncQop);
        return this;
    }

    /**
     * Get the x509CertificatePath property: SNC X509 certificate file path. Type: string (or Expression with resultType
     * string).
     * 
     * @return the x509CertificatePath value.
     */
    public Object x509CertificatePath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().x509CertificatePath();
    }

    /**
     * Set the x509CertificatePath property: SNC X509 certificate file path. Type: string (or Expression with resultType
     * string).
     * 
     * @param x509CertificatePath the x509CertificatePath value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withX509CertificatePath(Object x509CertificatePath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withX509CertificatePath(x509CertificatePath);
        return this;
    }

    /**
     * Get the logonGroup property: The Logon Group for the SAP System. Type: string (or Expression with resultType
     * string).
     * 
     * @return the logonGroup value.
     */
    public Object logonGroup() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logonGroup();
    }

    /**
     * Set the logonGroup property: The Logon Group for the SAP System. Type: string (or Expression with resultType
     * string).
     * 
     * @param logonGroup the logonGroup value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withLogonGroup(Object logonGroup) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLogonGroup(logonGroup);
        return this;
    }

    /**
     * Get the subscriberName property: The subscriber name. Type: string (or Expression with resultType string).
     * 
     * @return the subscriberName value.
     */
    public Object subscriberName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().subscriberName();
    }

    /**
     * Set the subscriberName property: The subscriber name. Type: string (or Expression with resultType string).
     * 
     * @param subscriberName the subscriberName value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withSubscriberName(Object subscriberName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSubscriberName(subscriberName);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the SapOdpLinkedService object itself.
     */
    public SapOdpLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model SapOdpLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SapOdpLinkedService.class);
}
