// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.SapOdpResourceDatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * SAP ODP Resource properties.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = SapOdpResourceDataset.class, visible = true)
@JsonTypeName("SapOdpResource")
@Fluent
public final class SapOdpResourceDataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SapOdpResource";

    /*
     * SAP ODP Resource properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private SapOdpResourceDatasetTypeProperties innerTypeProperties = new SapOdpResourceDatasetTypeProperties();

    /**
     * Creates an instance of SapOdpResourceDataset class.
     */
    public SapOdpResourceDataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: SAP ODP Resource properties.
     * 
     * @return the innerTypeProperties value.
     */
    private SapOdpResourceDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapOdpResourceDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapOdpResourceDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapOdpResourceDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapOdpResourceDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapOdpResourceDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapOdpResourceDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapOdpResourceDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the context property: The context of the SAP ODP Object. Type: string (or Expression with resultType string).
     * 
     * @return the context value.
     */
    public Object context() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().context();
    }

    /**
     * Set the context property: The context of the SAP ODP Object. Type: string (or Expression with resultType string).
     * 
     * @param context the context value to set.
     * @return the SapOdpResourceDataset object itself.
     */
    public SapOdpResourceDataset withContext(Object context) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withContext(context);
        return this;
    }

    /**
     * Get the objectName property: The name of the SAP ODP Object. Type: string (or Expression with resultType string).
     * 
     * @return the objectName value.
     */
    public Object objectName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().objectName();
    }

    /**
     * Set the objectName property: The name of the SAP ODP Object. Type: string (or Expression with resultType string).
     * 
     * @param objectName the objectName value to set.
     * @return the SapOdpResourceDataset object itself.
     */
    public SapOdpResourceDataset withObjectName(Object objectName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapOdpResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withObjectName(objectName);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model SapOdpResourceDataset"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SapOdpResourceDataset.class);
}
