// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A copy activity source for SAP Table source.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = SapTableSource.class, visible = true)
@JsonTypeName("SapTableSource")
@Fluent
public final class SapTableSource extends TabularSource {
    /*
     * Copy source type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SapTableSource";

    /*
     * The number of rows to be retrieved. Type: integer(or Expression with resultType integer).
     */
    @JsonProperty(value = "rowCount")
    private Object rowCount;

    /*
     * The number of rows that will be skipped. Type: integer (or Expression with resultType integer).
     */
    @JsonProperty(value = "rowSkips")
    private Object rowSkips;

    /*
     * The fields of the SAP table that will be retrieved. For example, column0, column1. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "rfcTableFields")
    private Object rfcTableFields;

    /*
     * The options for the filtering of the SAP Table. For example, COLUMN0 EQ SOME VALUE. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "rfcTableOptions")
    private Object rfcTableOptions;

    /*
     * Specifies the maximum number of rows that will be retrieved at a time when retrieving data from SAP Table. Type: integer (or Expression with resultType integer).
     */
    @JsonProperty(value = "batchSize")
    private Object batchSize;

    /*
     * Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "customRfcReadTableFunctionModule")
    private Object customRfcReadTableFunctionModule;

    /*
     * The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "sapDataColumnDelimiter")
    private Object sapDataColumnDelimiter;

    /*
     * The partition mechanism that will be used for SAP table read in parallel. Possible values include: "None", "PartitionOnInt", "PartitionOnCalendarYear", "PartitionOnCalendarMonth", "PartitionOnCalendarDate", "PartitionOnTime".
     */
    @JsonProperty(value = "partitionOption")
    private Object partitionOption;

    /*
     * The settings that will be leveraged for SAP table source partitioning.
     */
    @JsonProperty(value = "partitionSettings")
    private SapTablePartitionSettings partitionSettings;

    /**
     * Creates an instance of SapTableSource class.
     */
    public SapTableSource() {
    }

    /**
     * Get the type property: Copy source type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the rowCount property: The number of rows to be retrieved. Type: integer(or Expression with resultType
     * integer).
     * 
     * @return the rowCount value.
     */
    public Object rowCount() {
        return this.rowCount;
    }

    /**
     * Set the rowCount property: The number of rows to be retrieved. Type: integer(or Expression with resultType
     * integer).
     * 
     * @param rowCount the rowCount value to set.
     * @return the SapTableSource object itself.
     */
    public SapTableSource withRowCount(Object rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    /**
     * Get the rowSkips property: The number of rows that will be skipped. Type: integer (or Expression with resultType
     * integer).
     * 
     * @return the rowSkips value.
     */
    public Object rowSkips() {
        return this.rowSkips;
    }

    /**
     * Set the rowSkips property: The number of rows that will be skipped. Type: integer (or Expression with resultType
     * integer).
     * 
     * @param rowSkips the rowSkips value to set.
     * @return the SapTableSource object itself.
     */
    public SapTableSource withRowSkips(Object rowSkips) {
        this.rowSkips = rowSkips;
        return this;
    }

    /**
     * Get the rfcTableFields property: The fields of the SAP table that will be retrieved. For example, column0,
     * column1. Type: string (or Expression with resultType string).
     * 
     * @return the rfcTableFields value.
     */
    public Object rfcTableFields() {
        return this.rfcTableFields;
    }

    /**
     * Set the rfcTableFields property: The fields of the SAP table that will be retrieved. For example, column0,
     * column1. Type: string (or Expression with resultType string).
     * 
     * @param rfcTableFields the rfcTableFields value to set.
     * @return the SapTableSource object itself.
     */
    public SapTableSource withRfcTableFields(Object rfcTableFields) {
        this.rfcTableFields = rfcTableFields;
        return this;
    }

    /**
     * Get the rfcTableOptions property: The options for the filtering of the SAP Table. For example, COLUMN0 EQ SOME
     * VALUE. Type: string (or Expression with resultType string).
     * 
     * @return the rfcTableOptions value.
     */
    public Object rfcTableOptions() {
        return this.rfcTableOptions;
    }

    /**
     * Set the rfcTableOptions property: The options for the filtering of the SAP Table. For example, COLUMN0 EQ SOME
     * VALUE. Type: string (or Expression with resultType string).
     * 
     * @param rfcTableOptions the rfcTableOptions value to set.
     * @return the SapTableSource object itself.
     */
    public SapTableSource withRfcTableOptions(Object rfcTableOptions) {
        this.rfcTableOptions = rfcTableOptions;
        return this;
    }

    /**
     * Get the batchSize property: Specifies the maximum number of rows that will be retrieved at a time when retrieving
     * data from SAP Table. Type: integer (or Expression with resultType integer).
     * 
     * @return the batchSize value.
     */
    public Object batchSize() {
        return this.batchSize;
    }

    /**
     * Set the batchSize property: Specifies the maximum number of rows that will be retrieved at a time when retrieving
     * data from SAP Table. Type: integer (or Expression with resultType integer).
     * 
     * @param batchSize the batchSize value to set.
     * @return the SapTableSource object itself.
     */
    public SapTableSource withBatchSize(Object batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    /**
     * Get the customRfcReadTableFunctionModule property: Specifies the custom RFC function module that will be used to
     * read data from SAP Table. Type: string (or Expression with resultType string).
     * 
     * @return the customRfcReadTableFunctionModule value.
     */
    public Object customRfcReadTableFunctionModule() {
        return this.customRfcReadTableFunctionModule;
    }

    /**
     * Set the customRfcReadTableFunctionModule property: Specifies the custom RFC function module that will be used to
     * read data from SAP Table. Type: string (or Expression with resultType string).
     * 
     * @param customRfcReadTableFunctionModule the customRfcReadTableFunctionModule value to set.
     * @return the SapTableSource object itself.
     */
    public SapTableSource withCustomRfcReadTableFunctionModule(Object customRfcReadTableFunctionModule) {
        this.customRfcReadTableFunctionModule = customRfcReadTableFunctionModule;
        return this;
    }

    /**
     * Get the sapDataColumnDelimiter property: The single character that will be used as delimiter passed to SAP RFC as
     * well as splitting the output data retrieved. Type: string (or Expression with resultType string).
     * 
     * @return the sapDataColumnDelimiter value.
     */
    public Object sapDataColumnDelimiter() {
        return this.sapDataColumnDelimiter;
    }

    /**
     * Set the sapDataColumnDelimiter property: The single character that will be used as delimiter passed to SAP RFC as
     * well as splitting the output data retrieved. Type: string (or Expression with resultType string).
     * 
     * @param sapDataColumnDelimiter the sapDataColumnDelimiter value to set.
     * @return the SapTableSource object itself.
     */
    public SapTableSource withSapDataColumnDelimiter(Object sapDataColumnDelimiter) {
        this.sapDataColumnDelimiter = sapDataColumnDelimiter;
        return this;
    }

    /**
     * Get the partitionOption property: The partition mechanism that will be used for SAP table read in parallel.
     * Possible values include: "None", "PartitionOnInt", "PartitionOnCalendarYear", "PartitionOnCalendarMonth",
     * "PartitionOnCalendarDate", "PartitionOnTime".
     * 
     * @return the partitionOption value.
     */
    public Object partitionOption() {
        return this.partitionOption;
    }

    /**
     * Set the partitionOption property: The partition mechanism that will be used for SAP table read in parallel.
     * Possible values include: "None", "PartitionOnInt", "PartitionOnCalendarYear", "PartitionOnCalendarMonth",
     * "PartitionOnCalendarDate", "PartitionOnTime".
     * 
     * @param partitionOption the partitionOption value to set.
     * @return the SapTableSource object itself.
     */
    public SapTableSource withPartitionOption(Object partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    /**
     * Get the partitionSettings property: The settings that will be leveraged for SAP table source partitioning.
     * 
     * @return the partitionSettings value.
     */
    public SapTablePartitionSettings partitionSettings() {
        return this.partitionSettings;
    }

    /**
     * Set the partitionSettings property: The settings that will be leveraged for SAP table source partitioning.
     * 
     * @param partitionSettings the partitionSettings value to set.
     * @return the SapTableSource object itself.
     */
    public SapTableSource withPartitionSettings(SapTablePartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapTableSource withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapTableSource withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapTableSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapTableSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapTableSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SapTableSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (partitionSettings() != null) {
            partitionSettings().validate();
        }
    }
}
