// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ScheduleTriggerTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * Trigger that creates pipeline runs periodically, on schedule.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = ScheduleTrigger.class, visible = true)
@JsonTypeName("ScheduleTrigger")
@Fluent
public final class ScheduleTrigger extends MultiplePipelineTrigger {
    /*
     * Trigger type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "ScheduleTrigger";

    /*
     * Schedule Trigger properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private ScheduleTriggerTypeProperties innerTypeProperties = new ScheduleTriggerTypeProperties();

    /**
     * Creates an instance of ScheduleTrigger class.
     */
    public ScheduleTrigger() {
    }

    /**
     * Get the type property: Trigger type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Schedule Trigger properties.
     * 
     * @return the innerTypeProperties value.
     */
    private ScheduleTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScheduleTrigger withPipelines(List<TriggerPipelineReference> pipelines) {
        super.withPipelines(pipelines);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScheduleTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScheduleTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the recurrence property: Recurrence schedule configuration.
     * 
     * @return the recurrence value.
     */
    public ScheduleTriggerRecurrence recurrence() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().recurrence();
    }

    /**
     * Set the recurrence property: Recurrence schedule configuration.
     * 
     * @param recurrence the recurrence value to set.
     * @return the ScheduleTrigger object itself.
     */
    public ScheduleTrigger withRecurrence(ScheduleTriggerRecurrence recurrence) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ScheduleTriggerTypeProperties();
        }
        this.innerTypeProperties().withRecurrence(recurrence);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model ScheduleTrigger"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ScheduleTrigger.class);
}
