// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Custom script action to run on HDI ondemand cluster once it's up.
 */
@Fluent
public final class ScriptAction {
    /*
     * The user provided name of the script action.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The URI for the script action.
     */
    @JsonProperty(value = "uri", required = true)
    private String uri;

    /*
     * The node types on which the script action should be executed.
     */
    @JsonProperty(value = "roles", required = true)
    private Object roles;

    /*
     * The parameters for the script action.
     */
    @JsonProperty(value = "parameters")
    private String parameters;

    /**
     * Creates an instance of ScriptAction class.
     */
    public ScriptAction() {
    }

    /**
     * Get the name property: The user provided name of the script action.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The user provided name of the script action.
     * 
     * @param name the name value to set.
     * @return the ScriptAction object itself.
     */
    public ScriptAction withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the uri property: The URI for the script action.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: The URI for the script action.
     * 
     * @param uri the uri value to set.
     * @return the ScriptAction object itself.
     */
    public ScriptAction withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the roles property: The node types on which the script action should be executed.
     * 
     * @return the roles value.
     */
    public Object roles() {
        return this.roles;
    }

    /**
     * Set the roles property: The node types on which the script action should be executed.
     * 
     * @param roles the roles value to set.
     * @return the ScriptAction object itself.
     */
    public ScriptAction withRoles(Object roles) {
        this.roles = roles;
        return this;
    }

    /**
     * Get the parameters property: The parameters for the script action.
     * 
     * @return the parameters value.
     */
    public String parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The parameters for the script action.
     * 
     * @param parameters the parameters value to set.
     * @return the ScriptAction object itself.
     */
    public ScriptAction withParameters(String parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model ScriptAction"));
        }
        if (uri() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property uri in model ScriptAction"));
        }
        if (roles() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property roles in model ScriptAction"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ScriptAction.class);
}
