// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ScriptActivityTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * Script activity type.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = ScriptActivity.class, visible = true)
@JsonTypeName("Script")
@Fluent
public final class ScriptActivity extends ExecutionActivity {
    /*
     * Type of activity.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "Script";

    /*
     * Script activity properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private ScriptActivityTypeProperties innerTypeProperties = new ScriptActivityTypeProperties();

    /**
     * Creates an instance of ScriptActivity class.
     */
    public ScriptActivity() {
    }

    /**
     * Get the type property: Type of activity.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Script activity properties.
     * 
     * @return the innerTypeProperties value.
     */
    private ScriptActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScriptActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScriptActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScriptActivity withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScriptActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScriptActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScriptActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScriptActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScriptActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    /**
     * Get the scriptBlockExecutionTimeout property: ScriptBlock execution timeout. Type: string (or Expression with
     * resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @return the scriptBlockExecutionTimeout value.
     */
    public Object scriptBlockExecutionTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scriptBlockExecutionTimeout();
    }

    /**
     * Set the scriptBlockExecutionTimeout property: ScriptBlock execution timeout. Type: string (or Expression with
     * resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     * 
     * @param scriptBlockExecutionTimeout the scriptBlockExecutionTimeout value to set.
     * @return the ScriptActivity object itself.
     */
    public ScriptActivity withScriptBlockExecutionTimeout(Object scriptBlockExecutionTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ScriptActivityTypeProperties();
        }
        this.innerTypeProperties().withScriptBlockExecutionTimeout(scriptBlockExecutionTimeout);
        return this;
    }

    /**
     * Get the scripts property: Array of script blocks. Type: array.
     * 
     * @return the scripts value.
     */
    public List<ScriptActivityScriptBlock> scripts() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scripts();
    }

    /**
     * Set the scripts property: Array of script blocks. Type: array.
     * 
     * @param scripts the scripts value to set.
     * @return the ScriptActivity object itself.
     */
    public ScriptActivity withScripts(List<ScriptActivityScriptBlock> scripts) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ScriptActivityTypeProperties();
        }
        this.innerTypeProperties().withScripts(scripts);
        return this;
    }

    /**
     * Get the logSettings property: Log settings of script activity.
     * 
     * @return the logSettings value.
     */
    public ScriptActivityTypePropertiesLogSettings logSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logSettings();
    }

    /**
     * Set the logSettings property: Log settings of script activity.
     * 
     * @param logSettings the logSettings value to set.
     * @return the ScriptActivity object itself.
     */
    public ScriptActivity withLogSettings(ScriptActivityTypePropertiesLogSettings logSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ScriptActivityTypeProperties();
        }
        this.innerTypeProperties().withLogSettings(logSettings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model ScriptActivity"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ScriptActivity.class);
}
