// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The destination of logs. Type: string.
 */
public final class ScriptActivityLogDestination extends ExpandableStringEnum<ScriptActivityLogDestination> {
    /**
     * Static value ActivityOutput for ScriptActivityLogDestination.
     */
    public static final ScriptActivityLogDestination ACTIVITY_OUTPUT = fromString("ActivityOutput");

    /**
     * Static value ExternalStore for ScriptActivityLogDestination.
     */
    public static final ScriptActivityLogDestination EXTERNAL_STORE = fromString("ExternalStore");

    /**
     * Creates a new instance of ScriptActivityLogDestination value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ScriptActivityLogDestination() {
    }

    /**
     * Creates or finds a ScriptActivityLogDestination from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ScriptActivityLogDestination.
     */
    @JsonCreator
    public static ScriptActivityLogDestination fromString(String name) {
        return fromString(name, ScriptActivityLogDestination.class);
    }

    /**
     * Gets known ScriptActivityLogDestination values.
     * 
     * @return known ScriptActivityLogDestination values.
     */
    public static Collection<ScriptActivityLogDestination> values() {
        return values(ScriptActivityLogDestination.class);
    }
}
