// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters of a script block.
 */
@Fluent
public final class ScriptActivityParameter {
    /*
     * The name of the parameter. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "name")
    private Object name;

    /*
     * The type of the parameter.
     */
    @JsonProperty(value = "type")
    private ScriptActivityParameterType type;

    /*
     * The value of the parameter. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "value")
    private Object value;

    /*
     * The direction of the parameter.
     */
    @JsonProperty(value = "direction")
    private ScriptActivityParameterDirection direction;

    /*
     * The size of the output direction parameter.
     */
    @JsonProperty(value = "size")
    private Integer size;

    /**
     * Creates an instance of ScriptActivityParameter class.
     */
    public ScriptActivityParameter() {
    }

    /**
     * Get the name property: The name of the parameter. Type: string (or Expression with resultType string).
     * 
     * @return the name value.
     */
    public Object name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the parameter. Type: string (or Expression with resultType string).
     * 
     * @param name the name value to set.
     * @return the ScriptActivityParameter object itself.
     */
    public ScriptActivityParameter withName(Object name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of the parameter.
     * 
     * @return the type value.
     */
    public ScriptActivityParameterType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the parameter.
     * 
     * @param type the type value to set.
     * @return the ScriptActivityParameter object itself.
     */
    public ScriptActivityParameter withType(ScriptActivityParameterType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the value property: The value of the parameter. Type: string (or Expression with resultType string).
     * 
     * @return the value value.
     */
    public Object value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the parameter. Type: string (or Expression with resultType string).
     * 
     * @param value the value value to set.
     * @return the ScriptActivityParameter object itself.
     */
    public ScriptActivityParameter withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Get the direction property: The direction of the parameter.
     * 
     * @return the direction value.
     */
    public ScriptActivityParameterDirection direction() {
        return this.direction;
    }

    /**
     * Set the direction property: The direction of the parameter.
     * 
     * @param direction the direction value to set.
     * @return the ScriptActivityParameter object itself.
     */
    public ScriptActivityParameter withDirection(ScriptActivityParameterDirection direction) {
        this.direction = direction;
        return this;
    }

    /**
     * Get the size property: The size of the output direction parameter.
     * 
     * @return the size value.
     */
    public Integer size() {
        return this.size;
    }

    /**
     * Set the size property: The size of the output direction parameter.
     * 
     * @param size the size value to set.
     * @return the ScriptActivityParameter object itself.
     */
    public ScriptActivityParameter withSize(Integer size) {
        this.size = size;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
