// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The direction of the parameter.
 */
public final class ScriptActivityParameterDirection extends ExpandableStringEnum<ScriptActivityParameterDirection> {
    /**
     * Static value Input for ScriptActivityParameterDirection.
     */
    public static final ScriptActivityParameterDirection INPUT = fromString("Input");

    /**
     * Static value Output for ScriptActivityParameterDirection.
     */
    public static final ScriptActivityParameterDirection OUTPUT = fromString("Output");

    /**
     * Static value InputOutput for ScriptActivityParameterDirection.
     */
    public static final ScriptActivityParameterDirection INPUT_OUTPUT = fromString("InputOutput");

    /**
     * Creates a new instance of ScriptActivityParameterDirection value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ScriptActivityParameterDirection() {
    }

    /**
     * Creates or finds a ScriptActivityParameterDirection from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ScriptActivityParameterDirection.
     */
    @JsonCreator
    public static ScriptActivityParameterDirection fromString(String name) {
        return fromString(name, ScriptActivityParameterDirection.class);
    }

    /**
     * Gets known ScriptActivityParameterDirection values.
     * 
     * @return known ScriptActivityParameterDirection values.
     */
    public static Collection<ScriptActivityParameterDirection> values() {
        return values(ScriptActivityParameterDirection.class);
    }
}
