// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Script block of scripts.
 */
@Fluent
public final class ScriptActivityScriptBlock {
    /*
     * The query text. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "text", required = true)
    private Object text;

    /*
     * The type of the query. Please refer to the ScriptType for valid options. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "type", required = true)
    private Object type;

    /*
     * Array of script parameters. Type: array.
     */
    @JsonProperty(value = "parameters")
    private List<ScriptActivityParameter> parameters;

    /**
     * Creates an instance of ScriptActivityScriptBlock class.
     */
    public ScriptActivityScriptBlock() {
    }

    /**
     * Get the text property: The query text. Type: string (or Expression with resultType string).
     * 
     * @return the text value.
     */
    public Object text() {
        return this.text;
    }

    /**
     * Set the text property: The query text. Type: string (or Expression with resultType string).
     * 
     * @param text the text value to set.
     * @return the ScriptActivityScriptBlock object itself.
     */
    public ScriptActivityScriptBlock withText(Object text) {
        this.text = text;
        return this;
    }

    /**
     * Get the type property: The type of the query. Please refer to the ScriptType for valid options. Type: string (or
     * Expression with resultType string).
     * 
     * @return the type value.
     */
    public Object type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the query. Please refer to the ScriptType for valid options. Type: string (or
     * Expression with resultType string).
     * 
     * @param type the type value to set.
     * @return the ScriptActivityScriptBlock object itself.
     */
    public ScriptActivityScriptBlock withType(Object type) {
        this.type = type;
        return this;
    }

    /**
     * Get the parameters property: Array of script parameters. Type: array.
     * 
     * @return the parameters value.
     */
    public List<ScriptActivityParameter> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Array of script parameters. Type: array.
     * 
     * @param parameters the parameters value to set.
     * @return the ScriptActivityScriptBlock object itself.
     */
    public ScriptActivityScriptBlock withParameters(List<ScriptActivityParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (text() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property text in model ScriptActivityScriptBlock"));
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model ScriptActivityScriptBlock"));
        }
        if (parameters() != null) {
            parameters().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ScriptActivityScriptBlock.class);
}
