// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Execution policy for an activity that supports secure input and output.
 */
@Fluent
public final class SecureInputOutputPolicy {
    /*
     * When set to true, Input from activity is considered as secure and will not be logged to monitoring.
     */
    @JsonProperty(value = "secureInput")
    private Boolean secureInput;

    /*
     * When set to true, Output from activity is considered as secure and will not be logged to monitoring.
     */
    @JsonProperty(value = "secureOutput")
    private Boolean secureOutput;

    /**
     * Creates an instance of SecureInputOutputPolicy class.
     */
    public SecureInputOutputPolicy() {
    }

    /**
     * Get the secureInput property: When set to true, Input from activity is considered as secure and will not be
     * logged to monitoring.
     * 
     * @return the secureInput value.
     */
    public Boolean secureInput() {
        return this.secureInput;
    }

    /**
     * Set the secureInput property: When set to true, Input from activity is considered as secure and will not be
     * logged to monitoring.
     * 
     * @param secureInput the secureInput value to set.
     * @return the SecureInputOutputPolicy object itself.
     */
    public SecureInputOutputPolicy withSecureInput(Boolean secureInput) {
        this.secureInput = secureInput;
        return this;
    }

    /**
     * Get the secureOutput property: When set to true, Output from activity is considered as secure and will not be
     * logged to monitoring.
     * 
     * @return the secureOutput value.
     */
    public Boolean secureOutput() {
        return this.secureOutput;
    }

    /**
     * Set the secureOutput property: When set to true, Output from activity is considered as secure and will not be
     * logged to monitoring.
     * 
     * @param secureOutput the secureOutput value to set.
     * @return the SecureInputOutputPolicy object itself.
     */
    public SecureInputOutputPolicy withSecureOutput(Boolean secureOutput) {
        this.secureOutput = secureOutput;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
