// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Azure Data Factory secure string definition. The string value will be masked with asterisks '*' during Get or List
 * API calls.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = SecureString.class, visible = true)
@JsonTypeName("SecureString")
@Fluent
public final class SecureString extends SecretBase {
    /*
     * Type of the secret.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SecureString";

    /*
     * Value of secure string.
     */
    @JsonProperty(value = "value", required = true)
    private String value;

    /**
     * Creates an instance of SecureString class.
     */
    public SecureString() {
    }

    /**
     * Get the type property: Type of the secret.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the value property: Value of secure string.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Value of secure string.
     * 
     * @param value the value value to set.
     * @return the SecureString object itself.
     */
    public SecureString withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model SecureString"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SecureString.class);
}
