// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Self referenced tumbling window trigger dependency.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = SelfDependencyTumblingWindowTriggerReference.class,
    visible = true)
@JsonTypeName("SelfDependencyTumblingWindowTriggerReference")
@Fluent
public final class SelfDependencyTumblingWindowTriggerReference extends DependencyReference {
    /*
     * The type of dependency reference.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SelfDependencyTumblingWindowTriggerReference";

    /*
     * Timespan applied to the start time of a tumbling window when evaluating dependency.
     */
    @JsonProperty(value = "offset", required = true)
    private String offset;

    /*
     * The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used.
     */
    @JsonProperty(value = "size")
    private String size;

    /**
     * Creates an instance of SelfDependencyTumblingWindowTriggerReference class.
     */
    public SelfDependencyTumblingWindowTriggerReference() {
    }

    /**
     * Get the type property: The type of dependency reference.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the offset property: Timespan applied to the start time of a tumbling window when evaluating dependency.
     * 
     * @return the offset value.
     */
    public String offset() {
        return this.offset;
    }

    /**
     * Set the offset property: Timespan applied to the start time of a tumbling window when evaluating dependency.
     * 
     * @param offset the offset value to set.
     * @return the SelfDependencyTumblingWindowTriggerReference object itself.
     */
    public SelfDependencyTumblingWindowTriggerReference withOffset(String offset) {
        this.offset = offset;
        return this;
    }

    /**
     * Get the size property: The size of the window when evaluating the dependency. If undefined the frequency of the
     * tumbling window will be used.
     * 
     * @return the size value.
     */
    public String size() {
        return this.size;
    }

    /**
     * Set the size property: The size of the window when evaluating the dependency. If undefined the frequency of the
     * tumbling window will be used.
     * 
     * @param size the size value to set.
     * @return the SelfDependencyTumblingWindowTriggerReference object itself.
     */
    public SelfDependencyTumblingWindowTriggerReference withSize(String size) {
        this.size = size;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (offset() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property offset in model SelfDependencyTumblingWindowTriggerReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SelfDependencyTumblingWindowTriggerReference.class);
}
