// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A copy activity ServiceNowV2 server source.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = ServiceNowV2Source.class, visible = true)
@JsonTypeName("ServiceNowV2Source")
@Fluent
public final class ServiceNowV2Source extends TabularSource {
    /*
     * Copy source type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "ServiceNowV2Source";

    /*
     * Expression to filter data from source.
     */
    @JsonProperty(value = "expression")
    private ExpressionV2 expression;

    /**
     * Creates an instance of ServiceNowV2Source class.
     */
    public ServiceNowV2Source() {
    }

    /**
     * Get the type property: Copy source type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the expression property: Expression to filter data from source.
     * 
     * @return the expression value.
     */
    public ExpressionV2 expression() {
        return this.expression;
    }

    /**
     * Set the expression property: Expression to filter data from source.
     * 
     * @param expression the expression value to set.
     * @return the ServiceNowV2Source object itself.
     */
    public ServiceNowV2Source withExpression(ExpressionV2 expression) {
        this.expression = expression;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServiceNowV2Source withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServiceNowV2Source withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServiceNowV2Source withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServiceNowV2Source withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServiceNowV2Source withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServiceNowV2Source withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (expression() != null) {
            expression().validate();
        }
    }
}
