// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ServicePrincipalCredentialTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * Service principal credential.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = ServicePrincipalCredential.class,
    visible = true)
@JsonTypeName("ServicePrincipal")
@Fluent
public final class ServicePrincipalCredential extends Credential {
    /*
     * Type of credential.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "ServicePrincipal";

    /*
     * Service Principal credential properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private ServicePrincipalCredentialTypeProperties innerTypeProperties
        = new ServicePrincipalCredentialTypeProperties();

    /**
     * Creates an instance of ServicePrincipalCredential class.
     */
    public ServicePrincipalCredential() {
    }

    /**
     * Get the type property: Type of credential.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Service Principal credential properties.
     * 
     * @return the innerTypeProperties value.
     */
    private ServicePrincipalCredentialTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServicePrincipalCredential withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServicePrincipalCredential withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the servicePrincipalId property: The app ID of the service principal used to authenticate.
     * 
     * @return the servicePrincipalId value.
     */
    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    /**
     * Set the servicePrincipalId property: The app ID of the service principal used to authenticate.
     * 
     * @param servicePrincipalId the servicePrincipalId value to set.
     * @return the ServicePrincipalCredential object itself.
     */
    public ServicePrincipalCredential withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ServicePrincipalCredentialTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    /**
     * Get the servicePrincipalKey property: The key of the service principal used to authenticate.
     * 
     * @return the servicePrincipalKey value.
     */
    public AzureKeyVaultSecretReference servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    /**
     * Set the servicePrincipalKey property: The key of the service principal used to authenticate.
     * 
     * @param servicePrincipalKey the servicePrincipalKey value to set.
     * @return the ServicePrincipalCredential object itself.
     */
    public ServicePrincipalCredential withServicePrincipalKey(AzureKeyVaultSecretReference servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ServicePrincipalCredentialTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    /**
     * Get the tenant property: The ID of the tenant to which the service principal belongs.
     * 
     * @return the tenant value.
     */
    public Object tenant() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenant();
    }

    /**
     * Set the tenant property: The ID of the tenant to which the service principal belongs.
     * 
     * @param tenant the tenant value to set.
     * @return the ServicePrincipalCredential object itself.
     */
    public ServicePrincipalCredential withTenant(Object tenant) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ServicePrincipalCredentialTypeProperties();
        }
        this.innerTypeProperties().withTenant(tenant);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model ServicePrincipalCredential"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ServicePrincipalCredential.class);
}
