// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.SnowflakeLinkedV2ServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Snowflake linked service.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = SnowflakeV2LinkedService.class,
    visible = true)
@JsonTypeName("SnowflakeV2")
@Fluent
public final class SnowflakeV2LinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "SnowflakeV2";

    /*
     * Snowflake linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private SnowflakeLinkedV2ServiceTypeProperties innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();

    /**
     * Creates an instance of SnowflakeV2LinkedService class.
     */
    public SnowflakeV2LinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Snowflake linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private SnowflakeLinkedV2ServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SnowflakeV2LinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SnowflakeV2LinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SnowflakeV2LinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SnowflakeV2LinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the accountIdentifier property: The account identifier of your Snowflake account, e.g.
     * xy12345.east-us-2.azure.
     * 
     * @return the accountIdentifier value.
     */
    public Object accountIdentifier() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accountIdentifier();
    }

    /**
     * Set the accountIdentifier property: The account identifier of your Snowflake account, e.g.
     * xy12345.east-us-2.azure.
     * 
     * @param accountIdentifier the accountIdentifier value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withAccountIdentifier(Object accountIdentifier) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withAccountIdentifier(accountIdentifier);
        return this;
    }

    /**
     * Get the user property: The name of the Snowflake user.
     * 
     * @return the user value.
     */
    public Object user() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().user();
    }

    /**
     * Set the user property: The name of the Snowflake user.
     * 
     * @param user the user value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withUser(Object user) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withUser(user);
        return this;
    }

    /**
     * Get the password property: The Azure key vault secret reference of password in connection string.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    /**
     * Set the password property: The Azure key vault secret reference of password in connection string.
     * 
     * @param password the password value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    /**
     * Get the database property: The name of the Snowflake database.
     * 
     * @return the database value.
     */
    public Object database() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().database();
    }

    /**
     * Set the database property: The name of the Snowflake database.
     * 
     * @param database the database value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withDatabase(Object database) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withDatabase(database);
        return this;
    }

    /**
     * Get the warehouse property: The name of the Snowflake warehouse.
     * 
     * @return the warehouse value.
     */
    public Object warehouse() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().warehouse();
    }

    /**
     * Set the warehouse property: The name of the Snowflake warehouse.
     * 
     * @param warehouse the warehouse value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withWarehouse(Object warehouse) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withWarehouse(warehouse);
        return this;
    }

    /**
     * Get the authenticationType property: The type used for authentication. Type: string.
     * 
     * @return the authenticationType value.
     */
    public SnowflakeAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    /**
     * Set the authenticationType property: The type used for authentication. Type: string.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withAuthenticationType(SnowflakeAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    /**
     * Get the clientId property: The client ID of the application registered in Azure Active Directory for
     * AADServicePrincipal authentication.
     * 
     * @return the clientId value.
     */
    public Object clientId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientId();
    }

    /**
     * Set the clientId property: The client ID of the application registered in Azure Active Directory for
     * AADServicePrincipal authentication.
     * 
     * @param clientId the clientId value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withClientId(Object clientId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withClientId(clientId);
        return this;
    }

    /**
     * Get the clientSecret property: The Azure key vault secret reference of client secret for AADServicePrincipal
     * authentication.
     * 
     * @return the clientSecret value.
     */
    public SecretBase clientSecret() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientSecret();
    }

    /**
     * Set the clientSecret property: The Azure key vault secret reference of client secret for AADServicePrincipal
     * authentication.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withClientSecret(SecretBase clientSecret) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withClientSecret(clientSecret);
        return this;
    }

    /**
     * Get the tenantId property: The tenant ID of the application registered in Azure Active Directory for
     * AADServicePrincipal authentication.
     * 
     * @return the tenantId value.
     */
    public Object tenantId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenantId();
    }

    /**
     * Set the tenantId property: The tenant ID of the application registered in Azure Active Directory for
     * AADServicePrincipal authentication.
     * 
     * @param tenantId the tenantId value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withTenantId(Object tenantId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withTenantId(tenantId);
        return this;
    }

    /**
     * Get the scope property: The scope of the application registered in Azure Active Directory for AADServicePrincipal
     * authentication.
     * 
     * @return the scope value.
     */
    public Object scope() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scope();
    }

    /**
     * Set the scope property: The scope of the application registered in Azure Active Directory for AADServicePrincipal
     * authentication.
     * 
     * @param scope the scope value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withScope(Object scope) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withScope(scope);
        return this;
    }

    /**
     * Get the privateKey property: The Azure key vault secret reference of privateKey for KeyPair auth.
     * 
     * @return the privateKey value.
     */
    public SecretBase privateKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().privateKey();
    }

    /**
     * Set the privateKey property: The Azure key vault secret reference of privateKey for KeyPair auth.
     * 
     * @param privateKey the privateKey value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withPrivateKey(SecretBase privateKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withPrivateKey(privateKey);
        return this;
    }

    /**
     * Get the privateKeyPassphrase property: The Azure key vault secret reference of private key password for KeyPair
     * auth with encrypted private key.
     * 
     * @return the privateKeyPassphrase value.
     */
    public SecretBase privateKeyPassphrase() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().privateKeyPassphrase();
    }

    /**
     * Set the privateKeyPassphrase property: The Azure key vault secret reference of private key password for KeyPair
     * auth with encrypted private key.
     * 
     * @param privateKeyPassphrase the privateKeyPassphrase value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withPrivateKeyPassphrase(SecretBase privateKeyPassphrase) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withPrivateKeyPassphrase(privateKeyPassphrase);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the SnowflakeV2LinkedService object itself.
     */
    public SnowflakeV2LinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model SnowflakeV2LinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SnowflakeV2LinkedService.class);
}
