// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Spark configuration reference.
 */
@Fluent
public final class SparkConfigurationParametrizationReference {
    /*
     * Spark configuration reference type.
     */
    @JsonProperty(value = "type", required = true)
    private SparkConfigurationReferenceType type;

    /*
     * Reference spark configuration name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "referenceName", required = true)
    private Object referenceName;

    /**
     * Creates an instance of SparkConfigurationParametrizationReference class.
     */
    public SparkConfigurationParametrizationReference() {
    }

    /**
     * Get the type property: Spark configuration reference type.
     * 
     * @return the type value.
     */
    public SparkConfigurationReferenceType type() {
        return this.type;
    }

    /**
     * Set the type property: Spark configuration reference type.
     * 
     * @param type the type value to set.
     * @return the SparkConfigurationParametrizationReference object itself.
     */
    public SparkConfigurationParametrizationReference withType(SparkConfigurationReferenceType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the referenceName property: Reference spark configuration name. Type: string (or Expression with resultType
     * string).
     * 
     * @return the referenceName value.
     */
    public Object referenceName() {
        return this.referenceName;
    }

    /**
     * Set the referenceName property: Reference spark configuration name. Type: string (or Expression with resultType
     * string).
     * 
     * @param referenceName the referenceName value to set.
     * @return the SparkConfigurationParametrizationReference object itself.
     */
    public SparkConfigurationParametrizationReference withReferenceName(Object referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property type in model SparkConfigurationParametrizationReference"));
        }
        if (referenceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property referenceName in model SparkConfigurationParametrizationReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SparkConfigurationParametrizationReference.class);
}
